/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 24, 2004
 * Time: 1:13:09 PM
 * To change this template use Options | File Templates.
 */
package gui.run;

import utils.ReplaceString;

import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class ShortcutUtils {
    public static final char META_CHARACTER = '[';
    public static final char KEYSTRING_START = '{';
    public static final char KEYSTRING_END = '}';

    public static boolean hasAccelerator(
            String s) {
        int i1 = s.indexOf(KEYSTRING_START);
        int i2 = s.indexOf(KEYSTRING_END);
        if (i1 == -1 || i2 == -1) return false;
        return true;
    }

    /**
     * returns true if there is no META_CHARACTER
     * '[' and no KEYSTRING_START and no
     * KEYSTRING_END. E.g. no "{...}" pair.
     *
     * @param s
     * @return
     */
    public static boolean hasShortcut(String s) {
        int i1 = s.indexOf(META_CHARACTER);
        int i2 = s.indexOf(KEYSTRING_START);
        int i3 = s.indexOf(KEYSTRING_END);
        if (i1 == -1 &&
            ((i2 == -1) || (i3 == -1)))
            return false;
        return true;
    }

    public static char getMnemonicChar(String s) {
        if (-1 == s.indexOf(META_CHARACTER))
            return ' ';
        int i1 = s.indexOf(META_CHARACTER);
        return s.charAt(i1 + 1);
    }

    public static String getAcceleratorString(
            String s) {
        if (!hasAccelerator(s)) return "";
        return s.substring(
                s.indexOf(KEYSTRING_START) + 1,
                s.indexOf(KEYSTRING_END));
    }

    public static KeyStroke getKeyStroke(
            String s) {
        return KeyStroke.getKeyStroke(
                getAcceleratorString(s));
    }

    public static String stripMnemonicMetaChar(
            String s) {
        String newString =
                ReplaceString.replaceFirstInstance(
                        s,
                        META_CHARACTER + "",
                        "");
        return
                newString;
    }

    public static String stripAcceleratorString(
            String s) {
        if (!hasAccelerator(s))
            return s;
        int i = s.indexOf(KEYSTRING_START);
        return s.substring(0, i);
    }


    public static void print(Object o) {
        System.out.println(o);
    }

    /**
     * This was supposed to search the tab list
     * and add mnemonics, but, for some reason, it
     * does not work. This is the bug 4624207
     * http://developer.java.sun.com/developer/bugParade/bugs/4624207.html
     * and it was fixed in 1.5
     *
     * @param jtp
     */
    public static void addShortcut(
            JTabbedPane jtp) {
        int n = jtp.getTabCount();
        for (int i = 0; i < n; i++) {
            String s = jtp.getTitleAt(i);
            if (!hasShortcut(s)) continue;
            jtp.setMnemonicAt(i,
                              java.awt.event.KeyEvent.VK_1);
            jtp.setTitleAt(i,
                           stripMnemonicMetaChar(
                                   s));
        }

    }

    /**
     * "this is a shortcut [c" "this has no
     * shortcut [" "this has no shortcut either"
     *
     * @param ab
     */
    public static void addShortcut(
            AbstractButton ab) {
        addMnemonic(ab);
        addAccelerator(ab);
    }

    private static void addAccelerator(
            AbstractButton ab) {
        if (ab instanceof JMenuItem)
            addAccelerator((JMenuItem) ab);
    }

    private static void addMnemonic(
            AbstractButton ab) {
        String s = ab.getText();
        if (!hasMnemonic(s)) return;
        ab.setMnemonic(getMnemonicChar(s));
        ab.setText(stripMnemonicMetaChar(s));
    }

    private static boolean hasMnemonic(String s) {
        int mc = s.indexOf(META_CHARACTER);
        if (-1 == mc)
            return false;
        if (s.length() == mc - 1) return false;
        return true;
    }

    /**
     * Accelerator strings are embedded in the
     * label of a JMenuItem. For example: "my
     * label{alt shift X} "another label {control
     * DELETE} works on JCheckBoxMenuItem and
     * JRadioButtonMenuItem
     *
     * @param jmi
     */
    public static void addAccelerator(
            JMenuItem jmi) {
        print("Adding accelerator");
        String s = jmi.getText();
        testString(s);
        if (!hasAccelerator(s)) return;

        jmi.setAccelerator(getKeyStroke(s));
        jmi.setText(stripAcceleratorString(s));
    }

    public static void main(String args[]) {
        String s = "this is a [test{alt shift X}";
        testString(s);
    }

    private static void testString(String s) {
        print(s);
        print("stripChar=" +
              stripMnemonicMetaChar(s));
        print("The shortcut char=" +
              getMnemonicChar(s));
        print("hasKeyString=" +
              hasAccelerator(s));
        print("keyString=" +
              getAcceleratorString(s));
        print("keyStroke=" +
              KeyStroke.getKeyStroke(
                      getAcceleratorString(s)));
        print("stripKeyString=" +
              stripAcceleratorString(s));
    }
}
