package gui.run;

import javax.swing.JTextField;
import java.awt.event.ActionListener;


public abstract class RunTextField extends
        JTextField implements ActionListener, Runnable {
    String sTxt;

    public RunTextField(String text) {
        super(text);
        addActionListener(this);
    }

    public RunTextField() {
        addActionListener(this);
    }

    public RunTextField(int columns) {
        super(columns);
        addActionListener(this);
    }

    public RunTextField(String text, int columns) {
        super(text, columns);
        addActionListener(this);
    }

    public RunTextField(javax.swing.text.Document doc, String text, int columns) {
        super(doc, text, columns);
        addActionListener(this);
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame("RunTextField");
        java.awt.Container c = cf.getContentPane();
        c.add(new RunTextField("What is your name?") {
            public void run() {
                System.out.println(getText());
            }
        }
        );
        c.setLayout(new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}