package gui.run;

import gui.ClosableJFrame;

import javax.swing.JScrollBar;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.AdjustmentListener;
import java.awt.event.AdjustmentEvent;


public abstract class RunScroll
        extends JScrollBar
        implements
        AdjustmentListener,
        Runnable {

    public RunScroll(int orientation,
                     int value,
                     int extent,
                     int min,
                     int max) {
        super(orientation,
              value,
              extent,
              min,
              max);
        addAdjustmentListener(this);
    }

    public RunScroll(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public RunScroll() {
        this(VERTICAL);
    }

    public void adjustmentValueChanged(
            AdjustmentEvent ae) {
        run();
    }

    public static void main(String args[]) {
       ClosableJFrame cf = new ClosableJFrame();
        cf.setSize(200, 200);
       Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(new RunScroll() {
            public void run() {
                System.out.println(
                        "value=" + getValue());
            }
        }, BorderLayout.EAST);
        c.add(new RunScroll() {
            public void run() {
                System.out.println(
                        "value=" + getValue());
            }
        }, BorderLayout.WEST);
        c.add(new RunScroll(RunScroll.HORIZONTAL) {
            public void run() {
                System.out.println(
                        "value2=" + getValue());
            }
        }, BorderLayout.NORTH);
        c.add(new RunScroll(RunScroll.HORIZONTAL) {
            public void run() {
                System.out.println(
                        "value2=" + getValue());
            }
        }, BorderLayout.SOUTH);
        cf.setVisible(true);
    }


}