package gui.run;


public abstract class RunRadioButtonMenuItem extends
        javax.swing.JRadioButtonMenuItem implements
        java.awt.event.ActionListener, Runnable {
    public RunRadioButtonMenuItem(String label) {
        super(label);
        addActionListener(this);
    }

    public RunRadioButtonMenuItem(String label, javax.swing.ButtonGroup bg) {
        super(label);
        bg.add(this);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunRadioButtonMenuItem(
            String label,
            javax.swing.ButtonGroup bg,
            javax.swing.JPopupMenu jpum) {
        super(label);
        bg.add(this);
        jpum.add(this);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunRadioButtonMenuItem(String l, javax.swing.Icon i) {
        super(l, i);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunRadioButtonMenuItem(javax.swing.Icon i) {
        super(i);
        addActionListener(this);
    }

    public RunRadioButtonMenuItem() {
        addActionListener(this);
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame("RunRadioButtonMenuItem");
        java.awt.Container c = cf.getContentPane();
        javax.swing.ButtonGroup bg = new javax.swing.ButtonGroup();

        javax.swing.JMenuBar mb = new javax.swing.JMenuBar();
        RunMenu m = new RunMenu("[Scales");

        m.add(new RunRadioButtonMenuItem("[A harmonic Minor{ctrl shift A}", bg) {
            public void run() {
                System.out.println(getText() + "=" + isSelected());
            }
        });
        m.add(new RunRadioButtonMenuItem("[Chromatic{ctrl shift C}", bg) {
            public void run() {
                System.out.println(getText() + "=" + isSelected());
            }
        }
        );

        mb.add(m);
        cf.setJMenuBar(mb);
        c.setLayout(new java.awt.FlowLayout());
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}