package gui.run;

import gui.layouts.Alignable;
import gui.ClosableJFrame;

import javax.swing.Icon;
import javax.swing.JButton;
import java.awt.FlowLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public abstract class RunButton extends JButton
        implements ActionListener, Alignable,
        Runnable {
    public RunButton(String label) {
        this(label, null);
    }

    private int alignment = Alignable.CENTER;

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return alignment;
    }

    public RunButton(String l, Icon i) {
        super(l, i);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }


    public RunButton(Icon i) {
        this(null, i);
    }

    public RunButton() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }


    public static void main(String args[]) {
        // anonymous inner class
        // That uses the command pattern
        // also uses adapter pattern
        // since the normal
        // requires an
        // actionListener-
        // actionPerformed(ActionEvent e)
        // now we just need a run method.
        // Semantics for the runButton now include
        // an implicit metaChar='['


        ClosableJFrame cf =
                new ClosableJFrame(
                        "OK-CANCEL Frame");
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());

        c.add(new RunButton("[ok") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.add(new RunButton("[cancel") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.add(new RunButton("[delete files!") {
            public void run() {
                System.out.println(getText());
            }
        });
        cf.setSize(200, 200);
        cf.show();
    }

}