package gui.mouse;

import gui.ClosableJFrame;

import java.awt.event.MouseMotionListener;

public abstract class MouseController
        implements java.awt.event.MouseListener, MouseMotionListener {
    private java.awt.Point pressPoint;

    public void mouseMoved(java.awt.event.MouseEvent e) {
    }

    public void mouseReleased(java.awt.event.MouseEvent e) {
        released(e.getPoint());
    }

    public void mouseEntered(java.awt.event.MouseEvent e) {
    }

    public void mouseExited(java.awt.event.MouseEvent e) {
    }

    public void mouseClicked(java.awt.event.MouseEvent e) {
        if (e.getClickCount() == 2) {
            doubleClicked(e.getPoint());
            return;
        }
        if (e.isShiftDown() && e.getClickCount() == 1) {
            shiftClicked(e.getPoint());
            return;
        }
        clicked(e.getPoint());
    }

    public void mousePressed(java.awt.event.MouseEvent e) {
        pressPoint = e.getPoint();
        pressed(pressPoint);
    }

    public void mouseDragged(java.awt.event.MouseEvent e) {
        if (e.isShiftDown())
            dragShift(pressPoint, e.getPoint());
        else
            dragged(pressPoint, e.getPoint());
    }

    public abstract void released(java.awt.Point p);

    public abstract void dragged(
            java.awt.Point p1, java.awt.Point p2);

    public abstract void dragShift(
            java.awt.Point p1, java.awt.Point p2);

    public abstract void pressed(java.awt.Point p);

    public abstract void doubleClicked(java.awt.Point p);

    public abstract void clicked(java.awt.Point p);

    public abstract void shiftClicked(java.awt.Point p);

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        cf.addMouseController(new MouseController() {
            public void pressed(java.awt.Point p) {
                System.out.println("pressed:x,y=" + p.x + "," + p.y);
            }

            public void released(java.awt.Point p) {
                System.out.println("rel:x,y=" + p.x + "," + p.y);
            }

            public void dragShift(
                    java.awt.Point p1, java.awt.Point p2) {
                System.out.println(
                        "draShift:x1,y1,x2,y2=" + p1 + ": " + p2);
            }

            public void doubleClicked(java.awt.Point p) {
                System.out.println("d 2 clicked:x,y=" + p.x + "," + p.y);
            }

            public void clicked(java.awt.Point p) {
                System.out.println("clicked:x,y=" + p.x + "," + p.y);
            }

            public void shiftClicked(java.awt.Point p) {
                System.out.println("Sh clicked:x,y=" + p.x + "," + p.y);
            }

            public void dragged(
                    java.awt.Point p1, java.awt.Point p2) {
                System.out.println(
                        "dra:x1,y1,x2,y2=" + p1 + ": " + p2);
            }

        });
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}
