package gui.keyboard;

import gui.run.RunTextField;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class KeyLayout {
    static class TextModel {
        private String s = "";
        private RunTextField readOut;


        public void setReadOut(RunTextField _readOut) {
            readOut = _readOut;
        }

        public void ScreenKey(String _s) {
            s = s + _s;
            updateReadOut();
        }

        public void setState(String _s) {
            s = _s;
        }

        public void updateReadOut() {
            if (readOut == null) return;
            readOut.setText(s);
        }

        public String getS() {
            return s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public RunTextField getReadOut() {
            return readOut;
        }
    }

    class ButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o instanceof JButton) {
                JButton jb = (JButton) o;
                KeyLayout.tm.ScreenKey(jb.getText());
            }
        }
    }

    class ButtonFrame extends JFrame {
        ButtonFrame() {
            Container c = this.getContentPane();
            ButtonListener bc = new ButtonListener();
            c.setLayout(new GridLayout(5, 13));
            setSize(200, 200);
            setVisible(true);
        }

        public void addButton(Container c, char ch, ButtonListener bc) {
            JButton b = new JButton(ch + "");
            b.addActionListener(bc);
            c.add(b);
        }

        public void addButton(JPanel p, char ch, ButtonListener bc) {
            JButton b = new JButton(ch + "");
            b.addActionListener(bc);
            p.add(b);
        }

    }

    ButtonFrame bf = new ButtonFrame();
    ButtonListener bc = new ButtonListener();
    Container c = bf.getContentPane();

    JPanel FKeys = new JPanel();
    JPanel Letters = new JPanel();
    JPanel numbers = new JPanel();
    JPanel p = new JPanel();
    public static JPanel j = new JPanel();

    String s = "1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./\\";

    public static String st = "What is your name?";

    static TextModel tm = new TextModel();
    RunTextField textView = new RunTextField() {
        public void run() {
            tm.setState(getText());
        }
    };

    public JPanel addRow(char ca[], int min, int max) {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, max - min));
        for (int x = min; x < max; x++)
            bf.addButton(p, ca[x], bc);
        return p;
    }

    KeyLayout() {
        char ca[] = s.toCharArray();

        JPanel p = new JPanel();
        p.add(addRow(ca, 0, 12));
        p.add(addRow(ca, 12, 24));
        p.add(addRow(ca, 24, 35));
        p.add(addRow(ca, 35, ca.length));

        bf.addButton(c, ' ', bc);
        tm.setReadOut(textView);

        c.setLayout(new BorderLayout());
        c.add(textView, BorderLayout.NORTH);
        c.add(p, BorderLayout.CENTER);

        bf.setSize(200, 200);
        bf.setVisible(true);
    }

    public static void main(String args[]) {
        new KeyLayout();
    }
}