package gui.keyboard;


public class KeyController implements
        java.awt.event.KeyListener {
    public void keyPressed(java.awt.event.KeyEvent e) {
        char keyChar = e.getKeyChar();
        int keyCode = e.getKeyCode();
        String keyText = e.getKeyText(keyCode);

        int modifiers = e.getModifiers();
        String modifierText = e.getKeyModifiersText(modifiers);


        System.out.println("keyChar=" + (int) keyChar);
        System.out.println("keyText=" + keyText);
        System.out.println("modifiers=" + modifiers);
        System.out.println("modifierText=" + modifierText);

        System.out.println("processModifiers=" + processModifiers(e));


    }

    private String processModifiers(java.awt.event.KeyEvent e) {
        int modifiers = e.getModifiers();
        int keyCode = e.getKeyCode();
        String keyText = e.getKeyText(keyCode);

        String s = "";
        if ((modifiers & java.awt.event.InputEvent.META_MASK) != 0)
            s = s + "M-";

        if ((modifiers & java.awt.event.InputEvent.CTRL_MASK) != 0)
            s = s + "^-";

        if ((modifiers & java.awt.event.InputEvent.ALT_MASK) != 0)
            s = s + "A-";

        if ((modifiers & java.awt.event.InputEvent.SHIFT_MASK) != 0)
            s = s + "Shift-";

        return s + keyText;
    }

    public void keyTyped(java.awt.event.KeyEvent e) {
    }

    public void keyReleased(java.awt.event.KeyEvent e) {
        System.out.println(e);
    }
}