package gui.html;

import futils.Futil;
import futils.ReaderUtil;
import futils.WriterUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;

/**
 @author D. Lyon
 @version 1.1
 @see HtmlUtil
 */
public class HtmlUtil {


    private static void makeLinks() {
        File f = Futil.getReadFile("select a bookmarks file");
        BufferedReader br = ReaderUtil.getBufferedReader(f);
        FileWriter fw = WriterUtil.getFileWriter("Enter file.gui.html");
        PrintWriter pw = new PrintWriter(fw);
        String link;
        String line = null;
        // creating gui.html writeHeader for the output file
        String head =
                "<HTML> \n <BODY>\n <B><I>"
                + " Following HyperLinks are extracted from "
                + f + " <B><I><P>";
        // write the gui.html writeHeader
        pw.println(head);

        while (((line = ReaderUtil.readLine(br)) != null)) {
            link = getHyperLink(line);
            // extract the hyperlink from the line read from the input file
            if (link != null)
                pw.println("<LI><A HREF =\"" + link + "\">" + link + "</A><P>");

        }
        pw.println("</BODY> \n </HTML>");
        WriterUtil.close(fw);
    }

    /**
     * getHyperLink() - extract the hyperlinks from the line
     *
     *@param String - line from  the input file
     *
     *@return String - return the extracted hyperlink from the line
     */
    public static String getHyperLink(String l) {
        String link;
        StringTokenizer st = new StringTokenizer(l, "\"");
        int tc = st.countTokens();
        for (int i = 0; i < tc; i++) {
            String s = st.nextToken();
            if (s.indexOf("http") == 0) {
                return s;
            }
        }
        return null;
    }

    public static void main(String args[]) {
        HtmlUtil.makeLinks();
        System.out.println("done");
    }
}
