package gui.goslab;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GOSLAB
        extends Frame
        implements ActionListener {
    String labels[] = {"red", "green", "blue", "moo"};
    LabelControlPanel lcp = new LabelControlPanel(labels);
    ScrollbarPanel sbp = new ScrollbarPanel(labels.length);
    Panel panels[] = {sbp, lcp};

    ButtonControlPanel bcp = new ButtonControlPanel(this);

    static GridBagConstraintFrame gbcf =
            new GridBagConstraintFrame();

    public GOSLAB(
            GridBagConstraints gbcsb,
            GridBagConstraints gbclp,
            GridBagConstraints gbcbcp) {

        GridBagLayout gbl = new GridBagLayout();
        setLayout(gbl);
        gbl.setConstraints(sbp, gbcsb);
        gbl.setConstraints(lcp, gbclp);
        gbl.setConstraints(bcp, gbcbcp);
        add(sbp);
        add(lcp);
        add(bcp);
        setSize(200, 200);
        pack();
        setVisible(true);
    }

    public GOSLAB() {
        gbcf.setVisible(true);

        GridBagLayout ma = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 200;
        gbc.weighty = 200;
        setLayout(ma);
        ma.setConstraints(sbp, gbc);

        add(sbp);
        gbc.gridx = GridBagConstraints.RELATIVE;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        add(lcp);

        gbc.gridy = GridBagConstraints.BOTH;
        gbc.weightx = 100;

        ma.setConstraints(bcp, gbc);
        add(bcp);
        setSize(200, 200);
        pack();
        setVisible(true);

    }

    public static void main(
            String args[]) {
        new GOSLAB();
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == bcp.cancelButton) {
            setVisible(false);
            return;
        }
        if (o == bcp.okButton) {
            sbp.printValues();
            return;
        }
    }
}

class LabelControlPanel
        extends Panel {
    Label lba[];

    LabelControlPanel(
            String labels[]) {
        setLayout(new GridLayout(0, 1));
        lba =
                new Label[labels.length];
        for (int i = 0;
             i < labels.length; i++) {
            lba[i] = new Label(
                    labels[i]);
            add(lba[i]);
        }
    }
}

class ScrollbarPanel
        extends Panel {
    Scrollbar sba[];

    public int[] getValues() {
        int values[] = new int[sba.length];
        for (int i = 0;
             i < sba.length;
             i++)
            values[i] =
                    sba[i].getValue();

        return values;
    }

    public void printValues() {
        int values[] = getValues();
        for (int i = 0; i < values.length; i++)
            System.out.println(values[i]);
    }

    ScrollbarPanel(int N) {
        sba =
                new Scrollbar[N];
        GridBagLayout sbp = new GridBagLayout();
        GridBagConstraints sb = new GridBagConstraints();

        setLayout(sbp);
        sb.gridx = 0;
        sb.fill = GridBagConstraints.HORIZONTAL;
        sb.weightx = 200;
        sb.weighty = 200;

        int j = 20;
        for (int i = 0; i < sba.length; i++) {
            sba[i] =
                    new Scrollbar(
                            Scrollbar.HORIZONTAL);
            sba[i].setValue(50);
            sbp.setConstraints(sba[i], sb);
            add(sba[i]);
            sb.gridy = GridBagConstraints.RELATIVE;
            sb.fill = GridBagConstraints.HORIZONTAL;
            sb.weightx = 100;
            sb.weighty = 100;

        }
    }
}

class ButtonControlPanel extends
        Panel {
    Button okButton = new Button("ok");
    Button cancelButton = new Button("cancel");

    ButtonControlPanel(
            ActionListener al) {
        setLayout(new FlowLayout());
        add(okButton);
        add(cancelButton);
        okButton.addActionListener(al);
        cancelButton.addActionListener(al);
    }
}

class GridBagConstraintPanel
        extends Panel {
    TextField gxtf = new TextField("0");
    TextField gytf = new TextField("0");
    TextField gwtf = new TextField("1");
    TextField ghtf = new TextField("1");
    TextField gwxtf = new TextField("200");
    TextField gwytf = new TextField("200");
    TextField ipadxtf = new TextField("0");
    TextField ipadytf = new TextField("0");
    Choice fillChoice = new
            Choice();
    GridBagConstraints gbc = new GridBagConstraints();

    GridBagConstraintPanel() {
        setLayout(new GridLayout(0, 2));
        add(new Label("gridx="));
        add(gxtf);
        add(new Label("gridy="));
        add(gytf);
        add(new Label("gridHeight="));
        add(ghtf);
        add(new Label("gridWidth="));
        add(gwtf);
        add(new Label("weightx="));
        add(gwxtf);
        add(new Label("weighty="));
        add(gwytf);
        add(new Label("ipadx="));
        add(ipadxtf);
        add(new Label("ipady="));
        add(ipadytf);

        fillChoice.add("NONE");
        fillChoice.add("VERTICAL");
        fillChoice.add("HORIZONTAL");
        fillChoice.add("BOTH");
        add(new Label("fillChoice="));
        add(fillChoice);
    }

    GridBagConstraints getGridBagConstraints() {
        gbc.gridx = Integer.parseInt(gxtf.getText());
        gbc.gridy = Integer.parseInt(gytf.getText());
        gbc.gridwidth = Integer.parseInt(gwtf.getText());
        gbc.gridheight = Integer.parseInt(ghtf.getText());
        String fs = fillChoice.getSelectedItem();
        if (fs.equals("NONE"))
            gbc.fill = GridBagConstraints.NONE;
        if (fs.equals("VERTICAL"))
            gbc.fill = GridBagConstraints.VERTICAL;
        if (fs.equals("HORIZONTAL"))
            gbc.fill = GridBagConstraints.HORIZONTAL;
        if (fs.equals("BOTH"))
            gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = Integer.parseInt(gwxtf.getText());
        gbc.weighty = Integer.parseInt(gwytf.getText());
        gbc.ipadx = Integer.parseInt(ipadxtf.getText());
        gbc.ipady = Integer.parseInt(ipadytf.getText());
        return gbc;
    }
}

class GridBagConstraintFrame extends
        Frame implements ActionListener {
    ButtonControlPanel bcp
            = new ButtonControlPanel(this);
    GridBagConstraintPanel gbcpsb
            = new GridBagConstraintPanel();
    GridBagConstraintPanel gbcplp
            = new GridBagConstraintPanel();
    GridBagConstraintPanel gbcpbp
            = new GridBagConstraintPanel();

    GridBagConstraintFrame() {
        super("Scrollbar,Label & button Constraints");
        setLayout(new GridLayout(2, 0));
        add(gbcpsb);
        add(gbcplp);
        add(gbcpbp);
        add(bcp);
        pack();
        show();
    }

    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == bcp.okButton) {
            GOSLAB gl = new GOSLAB(
                    gbcpsb.getGridBagConstraints(),
                    gbcplp.getGridBagConstraints(),
                    gbcpbp.getGridBagConstraints());
            gl.pack();
            gl.show();

        }
    }
}


