package gui.browser;

import javax.swing.*;
import java.net.URL;

/**
 * Thread is set to gui.run in the lowest priority class.
 */


public class ThreadedLoad implements Runnable {
    Thread t = new Thread(this);
    URL u;
    JEditorPane jep;

    public ThreadedLoad(
            JEditorPane _jep, URL _u) {
        t.setPriority(Thread.MIN_PRIORITY);
        t.setDaemon(true);
        u = _u;
        jep = _jep;
        t.start();
    }

    /**
     *
     * External Thread
     *
     */

    public void setPriority(int i) {
        t.setPriority(i);
    }

    public void setDaemon(boolean b) {
        t.setDaemon(b);
    }


    public void run() {
        try {
            jep.setPage(u);
        } catch (Throwable t) {
            System.out.println("could not open:" + u);
        }
    }
}
