package gui.browser;

import futils.WriterUtil;

import javax.swing.*;
import java.awt.*;

/**
 * @author	Doug Lyon
 * @version	1.0
 */

public class Main extends gui.ClosableJFrame {

    private javax.swing.JEditorPane htmlPane =
            new javax.swing.JEditorPane();
    private javax.swing.JEditorPane textPane =
            new javax.swing.JEditorPane();

    private gui.run.RunTextField tf;
    private gui.run.RunMenuItem om;
    private gui.run.RunMenuItem sm;
    private gui.run.RunMenuItem vm;
    private gui.run.RunMenuItem bm;
    private gui.run.RunMenuItem fm;
    private gui.run.RunMenuItem em;

    BrowserLogic bl = new BrowserLogic(this);

    /**
     * Overloaded Constructor Browser2
     *
     */


    public Main() {
        super("DocJava Viewer");
        init();
        bl.backward();
    }


    public Main(javax.swing.JEditorPane jep) {
        super("My BrowserViewer");
        init();
        htmlPane.setText(jep.getText());
    }

    public void init() {

        java.awt.Container c = getContentPane();
        javax.swing.JMenuBar mb = new javax.swing.JMenuBar();
        gui.keyboard.MnemonicMenu m = new gui.keyboard.MnemonicMenu("File");

        om = new OpenMenuItem();
        sm = new SaveMenuItem();
        vm = new ViewMenuItem();
        fm = new ForwardMenuItem();
        bm = new BackwardMenuItem();
        em = new ExitMenuItem();
        JLabel label = new JLabel("Address");
        tf = new AddressFieldMenuItem();

        /**
         * Add menuItems to "File" menu.
         *
         */


        m.add(om);
        m.add(sm);
        m.add(vm);
        m.add(bm);
        m.add(fm);
        m.add(em);

        /**
         * Add Components to this container,
         * using the default FlowLayout.
         */

        mb.add(m);
        mb.add(label);
        mb.add(tf);
        c.add(mb, BorderLayout.NORTH);
        c.add(new javax.swing.JScrollPane(htmlPane));
        htmlPane.setEditable(false);
        setSize(900, 500);
        setLocation(50, 35);
        setVisible(true);
        htmlPane.addHyperlinkListener(new BrowserListener(bl, tf));
    }

    public JEditorPane getHtmlPane() {
        return htmlPane;
    }


    public void setHtml(String s) {
        htmlPane.setContentType("text/gui.html");
        htmlPane.setText(s);
    }

    public void setText(String s) {
        textPane.setContentType("text/plain");
        textPane.setText(s);
    }

    public void setTextField(String s) {
        tf.setText(s);
    }

    public void setString(String s) {
        setHtml(s);
    }

    public static void main(String args[]) {
        Main b = new Main();
    }

    /**
     * The following Named Inner Class that gui.run itseft.
     *
     */

    class OpenMenuItem extends gui.run.RunMenuItem {
        OpenMenuItem() {
            super("Open...");
        }

        public void run() {
            bl.openHtmlFile();
        }
    }

    class SaveMenuItem extends gui.run.RunMenuItem {
        SaveMenuItem() {
            super("Save...");
        }

        public void run() {
            WriterUtil.writeString(htmlPane.getText());
        }
    }

    class ViewMenuItem extends gui.run.RunMenuItem {
        ViewMenuItem() {
            super("View Source");
        }

        public void run() {
            new Main(htmlPane);
        }
    }

    class ForwardMenuItem extends gui.run.RunMenuItem {
        ForwardMenuItem() {
            super("Forward");
        }

        public void run() {
            bl.forward();
        }
    }

    class BackwardMenuItem extends gui.run.RunMenuItem {
        BackwardMenuItem() {
            super("Backward");
        }

        public void run() {
            bl.backward();
        }
    }

    class ExitMenuItem extends gui.run.RunMenuItem {
        ExitMenuItem() {
            super("Exit");
        }

        public void run() {
            System.exit(0);
        }
    }

    class AddressFieldMenuItem extends gui.run.RunTextField {
        AddressFieldMenuItem() {
            super(60);
        }

        public void run() {
            bl.processTextField(getText());
        }
    }


}