package gui.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;


/**
 * LinkQueue
 * Features:
 *		1. A way to go back to the previous link.
 *		2. A way to go forward to the next visited link.
 */

public class LinkQueue {
    private Vector v = new Vector();
    private int i = 0;
    BrowserLogic bl;

    public LinkQueue() {
        try {
            v.addElement(new URL("http://lyon.fairfield.edu"));
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void enQueue(URL u) {
        i++;
        v.add(i, u);
        System.out.println("en i = " + i + v.elementAt(i));

    }

    public URL next() {
        i++;
        if (i >= v.size()) i = 0;
        System.out.println("next i = " + i + v.elementAt(i));
        return (URL) v.elementAt(i);

    }

    public URL previous() {
        i--;
        if (i < 0) i = v.size() - 1;
        System.out.println("prev i = " + i + v.elementAt(i));
        return (URL) v.elementAt(i);

    }

    public String toString() {
        String s = "";
        for (int j = 0; j < 10; j++)
            s = s + (next()).toString() + "\n";
        return s;
    }

    public static void main(String args[]) throws
            MalformedURLException {
        LinkQueue lq = new LinkQueue();
//     System.out.println(lq);
    }
}
