/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package gui;

import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;

public class PseudoColorController
        extends JPanel {
    private double ar = 0.01;
    private double ag = 0.01;
    private double ab = 0.01;


    PseudoColorController(final IconUtils.OpenImageButton pseudoColorButton) {

        setLayout(new GridLayout(3, 0));
        add(new RunSlider() {
            public void run() {
                ar = scaleSlider(getValue());
                IconUtils.updateImage(ar, ag, ab, pseudoColorButton);
            }
        });
        add(new RunSlider() {
            public void run() {
                ag = scaleSlider(getValue());
                IconUtils.updateImage(ar, ag, ab, pseudoColorButton);
            }
        });
        add(new RunSlider() {
            public void run() {
                ab = scaleSlider(getValue());
                IconUtils.updateImage(ar, ag, ab, pseudoColorButton);
            }
        });
    }

    public static double scaleSlider(int t) {
        return 0.49 * (t / 100.0) + 0.01;
    }
}
