package gui;

import j2d.ShortImageBean;

public class Clipper {
    private static int min = 10000;
    private static int max = -10000;
    private boolean clipped = false;

    public static int getMin() {
        return min;
    }

    public static void setMin(int _min) {
        min = _min;
    }

    public static int getMax() {
        return max;
    }

    public static void setMax(int _max) {
        max = _max;
    }

    public short clip(short i) {
        if (i < getMin()) setMin(i);
        if (i > getMax()) setMax(i);
        if (i < 0) {
            setClipped(true);
            if (i < getMin()) setMin(i);
            return 0;
        }
        if (i > 255) {
            setClipped(true);
            return 255;
        }
        return i;
    }

    public void clip(ShortImageBean sib) {
        clip(sib.getR(), sib.getG(), sib.getB());
    }

    public void clip(short r[][], short g[][], short b[][]) {
        int width = r.length;
        int height = r[0].length;
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                r[x][y] = clip(r[x][y]);
                g[x][y] = clip(g[x][y]);
                b[x][y] = clip(b[x][y]);
            }
    }

    public boolean isClipped() {
        return clipped;
    }

    public void setClipped(boolean clipped) {
        this.clipped = clipped;
    }
}