package graphics.raytracers.tracer.primatives;

import graphics.raytracers.tracer.geometry.Ray3d;
import graphics.raytracers.tracer.geometry.Vector3d;

public class Sphere extends Primitive {
    Vector3d c;
    double r, r2;

    public Sphere(Vector3d center, double radius) {
        c = center;
        r = radius;
        r2 = r * r;
    }

    public Isect intersect(Ray3d ry) {
        double b, disc, t;
        Isect ip;
        Vector3d v;
        v = Vector3d.sub(c, ry.getStartPoint());
        b = Vector3d.dot(v, ry.getDirection());
        disc = b * b - Vector3d.dot(v, v) + r2;
        if (disc < 0.0) {
            return null;
        }
        disc = Math.sqrt(disc);
        t = (b - disc < 1e-6) ? b + disc : b - disc;
        if (t < 1e-6) {
            return null;
        }
        ip = new Isect();
        ip.t = t;
        ip.enter = Vector3d.dot(v, v) > r2 + 1e-6 ? 1 : 0;
        ip.prim = this;
        ip.surf = surf;
        return ip;
    }

    public Vector3d normal(Vector3d p) {
        Vector3d r;
        r = Vector3d.sub(p, c);
        r.normalize();
        return r;
    }

    public String toString() {
        return "Sphere {" + c.toString() + "," + r + "}";
    }
}
