package graphics.raytracers.raytracer.tracer;

class Vec3f {
    float x = 0;
    float y = 0;
    float z = 0;

    public Vec3f(float ix, float iy, float iz) {
        x = ix;
        y = iy;
        z = iz;
    }

    public Vec3f(Vec3f v) {
        x = v.x;
        y = v.y;
        z = v.z;
    }

    public void set(float nx, float ny, float nz) {
        x = nx;
        y = ny;
        z = nz;
    }

    public float getLength() {
        return
                (float) Math.sqrt(x * x + y * y + z * z);
    }

    public void normalize() {
        float length = getLength();

        try {
            x = x / length;
            y = y / length;
            z = z / length;
        } catch (ArithmeticException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public float dotProduct(Vec3f v) {
        return ((x * v.x + y * v.y + z * v.z));
    }

    // this = this crosses v
    public void crossProduct(Vec3f v) {
        float tmpx = y * v.z - z * v.y,
                tmpy = z * v.x - x * v.z,
                tmpz = x * v.y - y * v.x;
        x = tmpx;
        y = tmpy;
        z = tmpz;
    }

    public void mult(float factor) {
        x = x * factor;
        y = y * factor;
        z = z * factor;
    }

    public void add(Vec3f v) {
        x = x + v.x;
        y = y + v.y;
        z = z + v.z;
    }

    // subtracts v from this vector
    public void sub(Vec3f v) {
        x = x - v.x;
        y = y - v.y;
        z = z - v.z;
    }

    public String toString() {
        String res = new String("[" + x + ", " + y + ", " + z + "]");
        return res;
    }
}
