package graphics.graph;

import classUtils.reflection.TypeUtil;

import java.awt.*;

/**
 *	Start up the application.
 */
public class Main {
    public static void main(String args[]) {
        ControlPanel g = new ControlPanel();
        g = setupGraph();
        setupFrame(g);
        System.out.println("g.start");
    }

    private static void setupFrame(ControlPanel cp) {
        ClosableFrame f = new ClosableFrame();
        f.setSize(400, 400);
        f.setLayout(new BorderLayout());
        f.add(cp.getControlPanel(),
                BorderLayout.SOUTH);
        f.add(cp.getImagePanel(),
                BorderLayout.CENTER);
        f.setVisible(true);
        cp.start();
    }

    private static ControlPanel
            setupGraph2(ControlPanel g, Object o) {
        addClass(o.getClass(), g);
        return g;
    }

    private static void addClass(Class c, ControlPanel g) {
        String s;
        TypeUtil tu;
        s = TypeUtil.getTypeName(c);
        tu = new TypeUtil(c);
        tu.addClassesAndInterfaces();
        // tu.initAllFriends();
        add(g, s, tu.getAllClasses());
    }

    private static void add(ControlPanel cp, String s, Class ca[]) {
        for (int i = 0; i < ca.length; i++) {
            String cn = TypeUtil.getTypeName(ca[i]);
            cp.addEdge(s, cn);
        }
    }

    private static ControlPanel setupGraph() {
        ControlPanel g = new ControlPanel();
        String s = "net.AtomicClock";
        g.addEdge(s, "net.AutoServer");
        g.addEdge(s, "gui.html.Browser");
        g.addEdge(s, "addBk.addressBook.CSVExport");
        g.addEdge(s, "addBk.addressBook.CSVMerge");
        g.addEdge(s, "net.web.ChartServer");
        g.addEdge(s, "net.ComputeServer");
        g.addEdge(s, "net.ComputeThread");
        g.addEdge(s, "futils.CsvReader");
        g.addEdge(s, "net.DateServer");
        g.addEdge(s, "utils.Dos");
        g.addEdge(s, "addBk.addressBook.DosDialer");

        s = "futils.Futil";
        g.addEdge(s, "net.MainServer");
        g.addEdge(s, "futils.ReaderUtils");
        g.addEdge(s, "net.RemoteClassLoader");
        g.addEdge(s, "futils.SerializeTest");
        g.addEdge(s, "futils.SimpleWriter");
        g.addEdge(s, "net.Smtp");
        g.addEdge(s, "futils.StreamSniffer");
        g.addEdge(s, "net.web.WebServer");
        g.addEdge(s, "ip.gif.WriteGIF");
        g.addEdge(s, "xml.Xml2Cart");

        s = "net.web.ChartServer";
        g.addEdge(s, "graphics.ImageFrame");
        g.addEdge(s, "graphics.ImageUtils");
        g.addEdge(s, "graphics.sprials.Spirals");
        g.addEdge(s, "ip.gif.WriteGIF");


        s = "graphics.ImageUtils";
        g.addEdge(s, "net.web.ChartServer");
        g.addEdge(s, "graphics.ImageFrame");
        g.addEdge(s, "graphics.ImageUtils");
        g.addEdge(s, "graphics.sprials.Spirals");


        g.start();
        return g;
    }
}