package graphics.graph;

import java.awt.*;

public class ImageUtil
        /**
         *	The responsibility of this class is to aid in the
         *	creating of screen images for double buffering.
         */ {
    private Panel p = new Panel();
    private Image offscreen;
    private Dimension offscreensize;
    private Graphics offgraphics;

    public Graphics getOffGraphics() {
        return offgraphics;
    }

    public Dimension getOffScreenSize() {
        return offscreensize;
    }

    public Image getOffScreen() {
        return offscreen;
    }

    public void setPanel(Panel panel)
            /**
             *	this will let the ImageUtil perform what it
             *   needs to do on a specific desired panel.
             */ {
        p = panel;
    }

    public void createBuffer(Dimension d) {
        offscreen = p.createImage(d.width, d.height);
        offscreensize = d;
        if (offgraphics != null)
            offgraphics.dispose();
        offgraphics = offscreen.getGraphics();
        offgraphics.setFont(p.getFont());
    }
}