package graphics.graph;

import java.awt.*;

public class ImagePanel extends Panel
        /**
         *	The responsibility of this class is to provide an instance of a
         *	Panel that knows how to interface with the GraphManager. All it
         *	really does accept update the update message and cutils.delegate it
         *	appropriately.
         */ {
    private static ImagePanel ip = new ImagePanel();
    private GraphManager gm;

    private ImagePanel() {
    }

    public static ImagePanel getImagePanel()
            /**
             *	Static getter to support the singleton design pattern.
             *
             *	@return ImagePanel
             */ {
        return ip;
    }

    public void setGraphManager(GraphManager graphManager)
            /**
             *	Set the GraphManager. Even though GraphManager is a singleton,
             *	we didn't want to set it at instantiation time because ImagePanel
             *	(this) is also a singleton and GraphManager has a reference to this.
             *	To avoid confusion of circular instantiating, GraphManager sends
             *	a message here when it is ready to become referenced.
             *
             *	@param GraphManager
             */ {
        gm = graphManager;
    }

    public synchronized void update(Graphics g)
            /**
             *	Delegate the particulars of updating to the GraphManager.
             *
             *	@param Graphics
             */ {
        gm.update(g);
    }
}