package graphics.ddd;

import gui.mouse.MouseRotationController;
import gui.wutils.WindowController;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;


public class MainFrame extends Frame
        implements KeyListener {

    private RepaintThread repaintThread =
            new RepaintThread(this, 20);


    private boolean initialized = false;

    private Applet3d demo
            = new Applet3d(getSize().width, getSize().height);

    private MouseRotationController mc
            = new MouseRotationController(demo);
    private int mode;


    public static void main(String args[]) {
        image3D();
    }

    public static void image3D() {
        MainFrame f = new MainFrame();
        f.setSize(200, 200);
        f.setVisible(true);
        f.initialize();
        f.repaintThread().start();
        for (int i = 1; i <= f.demo.objects; i++) {
            f.demo.object[i].mode = 6;
        }

    }

    /**
     * Convert radial images into a solid
     * used for 3D image scanning via diffraction.
     */
    public void addScan(float radius[][]) {
        int scancolor = demo.getIntColor(60, 255, 20);
        demo.addObject(mode, scancolor);
        int obj = demo.objects;
        float twoPi = 2f * (float) Math.PI;
        int numberOfImages = radius[0].length;
        int h = radius.length;
        float deltaTheta = (twoPi / (numberOfImages - 1f));
        double deltaY = 3d / h;
        for (int imageNumber = 0; imageNumber < numberOfImages; imageNumber++)
            processEachImage(h, radius, imageNumber, deltaTheta, deltaY, obj);
        demo.generateScanObject(obj, h, numberOfImages - 1);
        demo.shiftObject(obj, (float) -1.2, (float) -0.5, (float) 1.3);
        demo.scaleObject(obj, (float) 0.5);
        demo.object[obj].texture = obj;
    }

    private void processEachImage(int h, float[][] radius,
                                  int imageNumber,
                                  float deltaTheta,
                                  double deltaY, int obj) {
        float x1;
        float y1;
        float z1;
        for (int y = 0; y < h; y++) {
            if (radius[y][imageNumber] > 0) {
                x1 = (float) (radius[y][imageNumber] * Math.sin((imageNumber * deltaTheta)));
                y1 = -1.5f + (float) (y * deltaY);
                z1 = (float) (radius[y][imageNumber] * Math.cos((imageNumber * deltaTheta)));
            } else {
                x1 = 0;
                y1 = -1.5f + (float) (y * deltaY);
                z1 = 0;
            }
            demo.addNode(obj, x1, y1, z1);
        }
    }

    public void initialize(Image i, float r[][]) {

        demo = new Applet3d(getSize().width, getSize().height);

        demo.addTexture(i);
        addScan(r);
        addLights();
        demo.reflectivity = 200;
        demo.setStatic();
        initialized = true;
        addListeners();
    }

    public static void image3D(Image img, short i[][]) {
        ip.raul.SnowManFrame.image3D(img, i);
    }

    public static void image3DBad(Image img, short s[][]) {
        MainFrame f = new MainFrame();
        f.setSize(200, 200);
        f.setVisible(true);
        f.initialize(img, s);
        f.repaintThread().start();
        for (int i = 1; i <= f.demo.objects; i++) {
            f.demo.object[i].mode = 6;
        }

    }


    public static void image3D(Image img, float r[][]) {
        MainFrame f = new MainFrame();
        f.setSize(400, 400);
        f.setVisible(true);
        f.initialize(img, r);
        f.repaintThread().start();
        for (int i = 1; i <= f.demo.objects; i++) {
            f.demo.object[i].mode = 6;
        }
    }

    public static MainFrame stepImage(Image img, short s[][]) {
        MainFrame f = new MainFrame();
        f.setSize(200, 200);
        f.setVisible(true);
        f.initialize(img, s);
        for (int i = 1; i <= f.demo.objects; i++) {
            f.demo.object[i].mode = 6;
        }
        return f;
    }


    public void keyPressed(KeyEvent e) {
    };
    public void keyReleased(KeyEvent e) {
    };

    public void addListeners() {
        new WindowController(this);
        addMouseListener(mc);
        addMouseMotionListener(mc);
        addKeyListener(this);
    }

    public void initialize() {
        initObjects();
        demo.addTexture(NumImage.getImage());
        addImageField();
        lightsAction();
    }

    public void initialize(Image i, short s[][]) {
        initObjects();
        demo.addTexture(i);
        addImageField(s);
        lightsAction();
    }

    private void lightsAction() {
        addLights();
        demo.reflectivity = 200;
        demo.setStatic();
        demo.rotateWorld((float) 90, (float) 0, 0);
        initialized = true;
    }

    private void initObjects() {

        addListeners();
    }

    public void paint(Graphics gx) {
        gx.setColor(Color.black);
        gx.fillRect(0, 0, getSize().width, getSize().height);
        gx.setColor(new Color(0, 255, 0));
        gx.drawLine(10, 26, 160, 26);
    }


    public void update(Graphics g) {
        if (initialized) {
            if (mc.isAutorot())
                demo.rotateWorld(3, -5, 2);
            demo.rotateObject(1, 0, 0, 5);
            g.drawImage(demo.renderScene(), 0, 0, this);
        } else {
            paint(g);
            initialize();
        }
    }

    void addImageField() {
        int fieldres = 20;
        int fieldcolor = demo.getIntColor(255, 96, 0);
        float map[][] = new float[fieldres][fieldres];
        for (int i = 2; i < fieldres; i++) {
            for (int j = 2; j < fieldres; j++) {
                int x = NumImage.gray.length * i / fieldres;
                int y = NumImage.gray[0].length * j / fieldres;
                map[i][j] = (float) (NumImage.gray[x][y] / 255.0);
            }
        }
        demo.generateField(map, fieldres, fieldres, mode, fieldcolor);
        demo.object[1].texture = 1;
        demo.rotateObject(1, 0, (float) 180, (float) 180);
        demo.shiftObject(1, 0, (float) 0.5, 0);
    }

    void addImageField(short s[][]) {
        int fieldres = 40;
        int fieldcolor = demo.getIntColor(255, 96, 0);
        float map[][] = new float[fieldres][fieldres];
        for (int i = 1; i < fieldres - 1; i++) {
            for (int j = 1; j < fieldres - 1; j++) {
                int x = s.length * i / fieldres;
                int y = s[0].length * j / fieldres;
                map[i][j] = (float) (s[x][y] / 255.0);
            }
        }
        demo.generateField(map, fieldres, fieldres, mode, fieldcolor);
        demo.object[1].texture = 1;
        demo.rotateObject(1, 0, (float) 180, (float) 180);
        demo.shiftObject(1, 0, (float) 0.5, 0);
    }

    void addField()
            // Adds a 3d field to the scene
    {
        int fieldres = 10;
        int fieldcolor = demo.getIntColor(255, 96, 0);
        float map[][] = new float[fieldres][fieldres];
        for (int i = 0; i < fieldres; i++) {
            for (int j = 0; j < fieldres; j++) {
                float x = (float) i / (float) fieldres * 2 - 1;
                float y = (float) j / (float) fieldres * 2 - 1;
                //map[i][j]=x*x*x*y-y*y*y*x;
                //map[i][j]=(float)(Math.cos(x*y*8)/10-Math.tan(x*y/2)/2);
                map[i][j] = x * x + y * y - (float) 0.5;
                //map[i][j]=(float)(Math.sin(x*y*8)/6-0.2);
            }
        }
        demo.generateField(map, fieldres, fieldres, mode, fieldcolor);
        demo.object[1].texture = 1;
        demo.rotateObject(1, 0, (float) 180, (float) 180);
        demo.shiftObject(1, 0, (float) 0.5, 0);
    }


    void addLights() {
        demo.ambient = 48;
        demo.setPhong(64);
        demo.addLight(new Vector3d((float) 0, (float) 0, (float) -1), 1, 164);
        demo.addLight(new Vector3d((float) 2, (float) -4, (float) -1), 1, 144);
    }

    public void keyTyped(KeyEvent e) {
        mode = (mode + 1) % 8;
        for (int i = 1; i <= demo.objects; i++)
            demo.object[i].mode = mode;
    }

    public RepaintThread repaintThread() {
        return repaintThread;
    }


}
