package graphics.charts;

import java.awt.*;

public class Ticks extends Canvas
        implements Paintable {
    private DoubleDataBean dd;
    private int xtickNumber = 1;
    private int ytickNumber = 1;

    public Ticks(DoubleDataBean _dd, Dimension d) {
        dd = _dd;
        setSize(d);
    }

    public void setNumberOfTicks(int _xtickNumber,
                                 int _ytickNumber) {
        xtickNumber = _xtickNumber;
        ytickNumber = _ytickNumber;
    }

    /**
     *	Draws the grid in the background of the line graphics.graph,
     if
     * 	it has been set to do so in the constructor
     (defaults to
     *	true). Grid runs length and width of each axis, at
     the
     *	increment value set in DoubleDataBean.getXIncrement()
     and
     *	DoubleDataBean.getYIncrement().
     *
     *	@param g 	Graphics context for drawing
     *	@see		LineGraph.#paint
     *	@see		DoubleDataBean.#getNumTicks
     *	@see		DoubleDataBean.#getXIncrement
     *	@see		DoubleDataBean.#getYIncrement
     *	@see		DoubleDataBean.#DeltaY
     *	@see		java.awt.Graphics.#drawLine
     */
    protected void drawGrid(Graphics g) {
        if (!dd.isGridOn()) return;
        Dimension d = getSize();
        int width = d.width;
        int height = d.height;
        int numXTicks = dd.getNumTicks
                (dd.getXVals(), width);
        int numYTicks = dd.getNumTicks(dd.getYVals(), height);
        double xIncrement = dd.getXIncrement();
        double deltaY = dd.getDeltaY();
        int yIncrement =
                (int) Math.round(dd.getYIncrement());
        g.setColor(Color.darkGray);

        //new code starts here
        double xCoord = dd.getXAxisCoord();
        double yCoord = dd.getYAxisCoord();
        // end new code

        //grid along X axis (horizontal lines)
        int yHeightPos = (int) (yCoord + yIncrement);
        int yHeightNeg = (int) (yCoord - yIncrement);

        int yLeft = 0;
        int yRight = width;

        while (yHeightPos > 0) {
            yHeightPos = yHeightPos - (yIncrement);
            g.drawLine(yLeft, yHeightPos, yRight, yHeightPos);
        }

        while (yHeightNeg < height) {
            yHeightNeg = yHeightNeg + yIncrement;
            g.drawLine(yLeft, yHeightNeg, yRight, yHeightNeg);
        }


        int xTop = 0;
        int xBottom = height;
        int xWidthPos = (int) (xCoord + xIncrement);
        int xWidthNeg = (int) (xCoord - xIncrement);

        while (xWidthPos > 0) {
            xWidthPos = xWidthPos - (int) xIncrement;
            g.drawLine(xWidthPos, xTop, xWidthPos, xBottom);
        }

        while (xWidthNeg < width) {
            xWidthNeg = xWidthNeg + (int) xIncrement;
            g.drawLine(xWidthNeg, xTop, xWidthNeg, xBottom);
        }


    }

    /**
     *	Draws the axes for the line graphics.graph and bar graphics.graph
     along the
     *	calculated X and Y origins.
     *
     *	@param g 	Graphics context for drawing
     *	@see		LineGraph.#paint
     *	@see		BarGraph.#paint
     *	@see		DoubleDataBean.#getXAxisCoord
     *	@see		DoubleDataBean.#getYAxisCoord
     *	@see		java.awt.Graphics.#drawLine
     */
    protected void drawAxes(Graphics g) {
        g.setColor(Color.blue);
        int xorig = (int) dd.getXAxisCoord();
        int yorig = (int) dd.getYAxisCoord();

        g.drawLine(0, yorig, getSize().width, yorig);
        g.drawLine(xorig, 0, xorig, getSize().height);

    }

    /**
     *	Draws the ticks along the axes for the line graphics.graph,
     if
     * 	it has been set to do so in the constructor
     (defaults to
     *	true). Ticks are hard coded to be two pixels on
     either side
     *	of each axis.
     *
     *	@param g 	Graphics context for drawing
     *	@see		LineGraph.#paint
     *	@see		DoubleDataBean.#getNumTicks
     *	@see		DoubleDataBean.#getXIncrement
     *	@see		DoubleDataBean.#getYIncrement
     *	@see		DoubleDataBean.#DeltaY
     *	@see		DoubleDataBean.#getXAxisCoord
     *	@see		DoubleDataBean.#getYAxisCoord
     *	@see		java.awt.Graphics.#drawLine
     */
    public void paint(Graphics g) {
        Dimension d = getSize();
        drawAxes(g);
        //drawGrid(g);
        int width = d.width;
        int height = d.height;
        double xIncrement = width / xtickNumber;
        double deltaY = dd.getDeltaY();
        double yIncrement = height / ytickNumber;

//Horizontal lines (along Y Axis)
        int xCoord = (int) dd.getXAxisCoord();
        int yCoord = (int) dd.getYAxisCoord();
        int yLeft = xCoord - 2;
        int yRight = xCoord + 2;
        int xTop = yCoord + 2;
        int xBottom = yCoord - 2;
        int yHeightPos = (int) (yCoord + yIncrement);
        int yHeightNeg = (int) (yCoord - yIncrement);
        int xWidthPos = (int) (xCoord + xIncrement);
        int xWidthNeg = (int) (xCoord - xIncrement);

        while (yHeightPos > 0) {
            yHeightPos = yHeightPos - ((int) yIncrement);
            g.drawLine(yLeft, yHeightPos, yRight, yHeightPos);

        }

        while (yHeightNeg < height) {
            yHeightNeg = yHeightNeg + (int) yIncrement;
            g.drawLine(yLeft, yHeightNeg, yRight, yHeightNeg);
        }

        while (xWidthPos > 0) {
            xWidthPos = xWidthPos - (int) xIncrement;
            g.drawLine(xWidthPos, xTop, xWidthPos, xBottom);
        }

        while (xWidthNeg < width) {
            xWidthNeg = xWidthNeg + (int) xIncrement;
            g.drawLine(xWidthNeg, xTop, xWidthNeg, xBottom);
        }


    }
}
