package graphics.carl;

// package mosaics ;

import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunTextField;

import java.awt.*;

//import Jgui.*;

public class Controller {
    //Image aBuffer = createImage(400,400);
    private javax.swing.JPanel panControls;

    private gui.run.RunTextField txt_shuffle;
    private gui.run.RunTextField txt_rings;
    private gui.run.RunTextField txt_rays;

    private java.awt.GradientPaint gp;
    private javax.swing.Timer myTimer = new javax.swing.Timer(100,
            new TimerCycleColor(this)
    );
    private final Logic logic;

    //------------------------
    // Constructor
    //------------------------
    Controller() {
        logic = new Logic("Log Polar JFrame");
        java.awt.Container c = logic.getClosableJFrame().getContentPane();

        // Construct default arrays ------
        newArray(logic.getRings(), logic.getRays(), logic.isRadially());

        // Set up display JPanel----------------
        setupDisplay();
        //panDisplay.setPreferredSize(new Dimension(300,300) );

        // ----- Set up control JPanel -----------------
        setupControlPanel();

        // ----------------------------------------
        getPanControls().add(new ResetRaysButton(this)
        );

        // ----------------------------------------
        getPanControls().add(new ShuffleButton());

        // ----------------------------------------
        setTxt_shuffle(
                new ShuffleTextfield());
        getPanControls().add(getTxt_shuffle());

        // ----------------------------------------
        getPanControls().add(new RingRaysButton(this)
        );

        // ----------------------------------------
        setTxt_rings(new RingNumberTextField(this));
        getPanControls().add(getTxt_rings());

        // ----------------------------------------
        setTxt_rays(new RaysTextField(this));
        getPanControls().add(getTxt_rays());

        getPanControls().add(new BackGroundColorButton(this)
        );

        getPanControls().add(
                new TimerToggleButton(this)
        );

        getPanControls().add(
                new ConcentricRadialButton(this)
        );

        // ----- Add panels to JFrame, and show ---------
        addPanelsToFrameAndShow(c);

    } // End constructor ----------------------

    private void setupDisplay() {
        logic.setPanDisplay(new PaintPanel(this));
        logic.getPanDisplay().setBackground(java.awt.Color.darkGray);
    }

    private void setupControlPanel() {
        setPanControls(new javax.swing.JPanel());
        getPanControls().setOpaque(false); // avoid repainting background
        getPanControls().setBackground(java.awt.Color.lightGray);
        getPanControls().setLayout(new java.awt.FlowLayout());
    }

    private void addPanelsToFrameAndShow(java.awt.Container c) {
        logic.getClosableJFrame().setSize(400, 400);
        logic.getPanDisplay().setLayout(new java.awt.FlowLayout());
        getPanControls().setLayout(new java.awt.FlowLayout());
        c.setLayout(new java.awt.GridLayout(0, 1));
        c.add(logic.getPanDisplay());
        ClosableJFrame pf = new ClosableJFrame("controls");
        pf.setSize(200, 200);
        pf.getContentPane().add(getPanControls());
        pf.setVisible(true);
        logic.getClosableJFrame().show();
    }


    public void newArray(int _rings, int _rays, boolean _radial) {
        java.awt.Dimension d = logic.getClosableJFrame().getSize();
        int w = d.width;
        int h = d.height;
        double r = w / 2; //to do, use size of screen
        // to compute the inner radius
        logic.setLppArray(new PointArray(_rings, _rays,
                new java.awt.geom.Point2D.Float(300f, 300f), 20f));
        logic.setCArray(new ColorArray(_rings, _rays, _radial));
    } // --------------------------------------


    // ----------------------------------------
    public static void draw(Controller controller, java.awt.Graphics g) {
        java.awt.Graphics2D g2 = (java.awt.Graphics2D) g;
        float x, y, r;
        int rays = controller.logic.getLppArray().get_rayCount();
        int rings = controller.logic.getLppArray().get_ringCount();
        controller.setRenderingHints(g2);

        //Draw circlets
        controller.drawCirclets(rays, rings, g2);
    } // End draw()

    private void setRenderingHints(java.awt.Graphics2D g2) {
        java.awt.RenderingHints qualityHints;
        qualityHints = new
                java.awt.RenderingHints(RenderingHints.KEY_ANTIALIASING,
                        RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(qualityHints);
    }

    private void drawCirclets(int rays, int rings, java.awt.Graphics2D g2) {
        float x;
        float y;
        float r;
        for (int i_ray = 0; i_ray < rays; i_ray++) {
            drawRings(rings, i_ray, rays, g2);
        }
    }

    private void drawRings(int rings,
                           int i_ray,
                           int rays,
                           java.awt.Graphics2D g2) {
        float x;
        float y;
        float r;
        for (int i_ring = 0; i_ring < rings; i_ring++) {
            x = logic.getLppArray().getPts()[i_ring][i_ray].x;
            y = logic.getLppArray().getPts()[i_ring][i_ray].y;
            r = logic.getLppArray().getRadii()[i_ring];
            logic.e2d.setFrame(
                    x - r, y - r, 2f * r, 2f * r);
//					g2.setPaint(cArray.colorArray[i_ring][i_ray]);
            logic.p2.setLocation(x - r, y + r);
            logic.p1.setLocation(x + r, y + r);
            logic.color1 = logic.getCArray().getColorArray()[i_ring][(i_ray + logic.getIOffset()) % rays];
            logic.color2 = logic.getCArray().getColorArray()[i_ring][(i_ray + logic.getIOffset() + rays / 6) % rays];
//					color2 = color1.brighter().brighter().brighter();
//

            g2.setPaint(java.awt.Color.white);
            g2.draw(logic.e2d);
            //		g2.setPaint(color1);
            gp
                    = new java.awt.GradientPaint(logic.p1, logic.color1, logic.p2, logic.color2);
            g2.setPaint(gp);
            g2.fill(logic.e2d);
//				GradientPaint gp = new GradientPaint(p1, color1, p2, color2);

            //	GradientPaint(Point2D pt1, Color color1, Point2D pt2, Color color2, boolean cyclic)

        }
    }

    public javax.swing.JPanel getPanControls() {
        return panControls;
    }

    public void setPanControls(javax.swing.JPanel panControls) {
        this.panControls = panControls;
    }

    public RunTextField getTxt_shuffle() {
        return txt_shuffle;
    }

    public void setTxt_shuffle(RunTextField txt_shuffle) {
        this.txt_shuffle = txt_shuffle;
    }

    public RunTextField getTxt_rings() {
        return txt_rings;
    }

    public void setTxt_rings(RunTextField txt_rings) {
        this.txt_rings = txt_rings;
    }

    public RunTextField getTxt_rays() {
        return txt_rays;
    }

    public void setTxt_rays(RunTextField txt_rays) {
        this.txt_rays = txt_rays;
    }

    public void toggleTimer() {
        if (logic.isTimerON()) {
            getMyTimer().stop();
            logic.setTimerON(false);
//				iOffset = 0;
            return;
        }
        logic.setTimerON(true);
        getMyTimer().start();
        logic.getClosableJFrame().repaint();
    }

    public javax.swing.Timer getMyTimer() {
        return myTimer;
    }

    public void setMyTimer(javax.swing.Timer myTimer) {
        this.myTimer = myTimer;
    }

    public Logic getLogic() {
        return logic;
    }

    class ShuffleButton extends RunButton {

        public ShuffleButton() {
            super("Shuffle by:");
        }

        public void run() {
            logic.getCArray().shuffleRays(logic.getShuffleBundle());
            logic.getPanDisplay().repaint();
        }
    }

    class ShuffleTextfield extends RunTextField {
        public ShuffleTextfield() {
            super("1", 6);
        }

        public void run() {
            logic.setShuffleBundle(Integer.parseInt(getText()));
        }
    }

}
