package futils;

import java.io.File;
import java.io.FilenameFilter;


public class WildFilter implements FilenameFilter {
    private String suffix = null;
    private String prefix = null;

    public WildFilter(String suffix_) {
        suffix = suffix_;
    }

    public WildFilter(String _prefix, String _suffix) {
        suffix = _suffix;
        prefix = _prefix;
    }

    public boolean accept(File dir, String name) {
        if (prefix == null) return name.endsWith(suffix);
        if (suffix == null) return name.startsWith(prefix);
        return name.endsWith(suffix) && name.startsWith(prefix);
    }
}

