package futils;

import java.io.*;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.Date;

public class SerializeTest {
    // futils.SerializeTest

    public static Object readObject()
            throws
            IOException,
            FileNotFoundException,
            ClassNotFoundException {
        ObjectInputStream ois
                = new ObjectInputStream(
                        new GZIPInputStream(
                                new FileInputStream(
                                        Futil.getReadFile(
                                                "select an object")
                                )
                        )
                );
        return ois.readObject();

    }

    public static Object readObjectUncompressed()
            throws
            IOException,
            FileNotFoundException,
            ClassNotFoundException {
        FileInputStream fis
                = new FileInputStream(
                        Futil.getReadFile("select an object"));
        ObjectInputStream ois
                = new ObjectInputStream(fis);
        Object o = ois.readObject();
        fis.close();
        return o;
    }

    public static void saveObject(Object o)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(
                        Futil.getWriteFile(
                                "select an output file for the object"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        ObjectOutputStream oos
                = new ObjectOutputStream(gos);
        oos.writeObject(o);
        oos.close();
        gos.finish();
    }

    public static void saveString(String s)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(
                        Futil.getWriteFile(
                                "select an output file for the object"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        byte b[] = s.getBytes();
        gos.write(b);
        gos.finish();
    }

    public static void saveObjectUncompressed(Object o)
            throws IOException {
        FileOutputStream fos
                = new FileOutputStream(
                        Futil.getWriteFile(
                                "select an output file for the object"));
        ObjectOutputStream oos
                = new ObjectOutputStream(fos);
        oos.writeObject(o);
        oos.close();
    }

    public static void print(Customer c[]) {
        for (int i = 0; i < c.length; i++)
            c[i].print();
    }

    public static void main(String args[]) {
        try {
            regressionTest();
            saveString("this is a test of a compressed string");
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        } catch (ClassNotFoundException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        }
    }

    private static void regressionTest()
            throws IOException, ClassNotFoundException {
        testUncompressedSave();
        testCompressedSave();
    }

    private static void testUncompressedSave()
            throws IOException, ClassNotFoundException {
        Customer c1[] = new Customer[100];
        for (int i = 0; i < 100; i++) {
            c1[i] = new Customer();
            c1[i].setName("cust#" + i);
        }

        System.out.println("Object out=");
        SerializeTest.saveObjectUncompressed(c1);
        System.out.println("Object in=");
        Object o =
                SerializeTest.readObjectUncompressed();
        if (o instanceof Customer[]) {
            Customer c[] =
                    (Customer[]) o;
            print(c);
        }
    }

    private static void testCompressedSave()
            throws IOException, ClassNotFoundException {
        Customer c1[] = new Customer[100];
        for (int i = 0; i < 100; i++) {
            c1[i] = new Customer();
            c1[i].setName("cust#" + i);
        }

        System.out.println("Object out=");
        saveObject(c1);
        System.out.println("Object in=");
        Object o =
                readObject();
        if (o instanceof Customer[]) {
            Customer c[] =
                    (Customer[]) o;
            print(c);
        }
    }
}