package futils;

import java.io.BufferedReader;

public class PolymorphicProcessor {
    LineProcessor lp = null;

    public PolymorphicProcessor(LineProcessor _lp) {
        lp = _lp;
        process();
    }

    public void process() {
        BufferedReader br =
                ReaderUtil.getBufferedReader("select text file");
        String s = null;
        while ((s = ReaderUtil.readLine(br)) != null) {
            lp.process(s);
        }
        ReaderUtil.close(br);

    }

    public static void testPolyProcessor() {
        new PolymorphicProcessor(
                new LineProcessor() {
                    public void process(String s) {
                        System.out.println(s);
                    }
                }
        );
    }
}




