/*
 * @author Douglas A. Lyon
 * @version  Oct 28, 2002.8:07:15 AM
 */
package futils;

import javax.swing.*;
import java.awt.*;
import java.awt.image.ImageObserver;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Out {
    public static void messageDialog(Object o) {
        JOptionPane.showMessageDialog(null, o);
    }

    public static void println() {
        System.out.println();
    }

    public static void print(int i) {
        System.out.print(i);
    }

    public static void print(double d) {
        System.out.print(d);
    }

    public static void println(long i) {
        System.out.println(i);
    }

    public static void println(double d) {
        System.out.println(d);
    }

    public static void println(Object i) {
        System.out.println(i);
    }

    public static void print(Object d) {
        System.out.print(d);
    }

    public static void main(String args[]) {
        messageDialog("Hello World");
    }

    public static void saveAsJava(
            PrintWriter pw, Image img, ImageObserver io) {
        int g;
        int width = img.getWidth(io);
        int height = img.getHeight(io);
        short r[][] = j2d.ImageUtils.getGreenFromImage(img, io);


        pw.println("package ip.gui;\n"
                + "\nclass NumImage {\n"
                + "\tpublic static short gray[][] = {\n");

        for (int y = 0; y < height; y++) {
            pw.print("{");
            for (int x = 0; x < width - 1; x++) {
                g = r[x][y];
                if (g < 10)
                    pw.print("  ");
                else if (g < 100) pw.print(" ");
                pw.print(g + ", ");
            }
            pw.println(r[width - 1][y] + "},");

        }
        pw.println("};}");
        System.out.println("Done writing image");

    }

    public static void saveAsJava(String fn, Image img, ImageObserver io) {
        try {
            FileWriter fw =
                    new FileWriter(fn);
            PrintWriter pw =
                    new PrintWriter(fw);
            saveAsJava(pw, img, io);
            pw.flush();
            fw.close();
        } catch (Exception e) {
        }
    }
}
