package futils;

import java.io.File;
import java.util.Vector;

// futils.FileList

public class FileList {

    // This vector will hold all the file names.
    private static Vector v = new Vector();

    public static File[] getFiles() {
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    private static FileFilter ff = new FileFilter();
    private static final DirFilter df = new DirFilter();

    // Recurse through all subdirectories and store
    // all the file names in a vector.
    public static void list(File directory) {

        add(directory.listFiles(ff));
        String dirs[] = directory.list(df);

        if (dirs == null) return;

        for (int i = 0; i < dirs.length; i++) {
            list(new File(directory, dirs[i]));
        }
    }

    public static void list(File directory, WildFilter wf) {

        add(directory.listFiles(wf));
        String dirs[] = directory.list(df);

        if (dirs == null) return;

        for (int i = 0; i < dirs.length; i++) {
            list(new File(directory, dirs[i]), wf);
        }
    }

    public static void delete() {
        File f[] = getFiles();
        for (int i = 0; i < f.length; i++) {
            f[i].delete();
        }
    }

    private static void add(File f[]) {
        if (f != null) {
            for (int i = 0; i < f.length; i++)
                v.addElement(f[i]);
        }
    }

    public static void print() {
        int VectorSize = v.size();
        for (int i = 0; i < VectorSize; i++)
            System.out.println(v.elementAt(i));
    }

    public static void main(String args[]) {
        File f =
                Futil.getReadDirFile(
                        "select a start file");
        //list(f);
        WildFilter wf = new WildFilter(".class");
        list(f, wf);
        print();

        System.out.println(
                "-----------------------");
        System.out.println(
                "Total number of files = "
                + v.size());
    }
}