package futils;

import java.io.File;
import java.util.Collections;
import java.util.Vector;

/**
 * DirList, w/o recursion.
 */
public class DirList {
    private File startDir;
    private Vector history = new Vector();
    private int totalBytes = 0;
    private String suffix = null;
    private boolean verbose = false;

    public static void main(String args[]) {
        DirList dl = new DirList("java.exe");
        dl.sort();
        dl.printFiles();
        dl.printStats();
    }

    public void sort() {
        Collections.sort(history);
    }

    public DirList(String _suffix) {
        suffix = _suffix;
        startDir = Futil.getReadDirFile(
                "select a *." + suffix + " file");
        startAtThisDir(startDir);
    }

    public DirList(File _startDir, String _suffix) {
        startDir = _startDir;
        startAtThisDir(startDir);
    }

    public void printStats() {
        System.out.println(
                "Saw " +
                getTotalFiles() +
                " *" +
                suffix +
                " files with a total size of " +
                totalBytes +
                " bytes");
    }

    public void printFiles() {
        File f[] = getFiles();
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }

    public final void printVerbose(Object o) {
        if (verbose)
            System.out.println(o);
    }

    //-------------------------------------------------------
    // Recursive function that given an anchor directory
    // will walk directory gui.tree
    //
    //-------------------------------------------------------
    public void startAtThisDir(File f1) {
        printVerbose("Selected -> " + f1);
        printVerbose("Files in this Directory: ");
        addFilesInThisDirectory(f1);
        processAllDirectoriesInThisDirectory(f1);
    }

    private Vector vecDir = new Vector();

    private File nextDir() {
        return (File) vecDir.remove(vecDir.size() - 1);
    }

    private void addDirs(File dirList[]) {
        if (dirList == null) return;
        for (int i = 0; i < dirList.length; i++)
            vecDir.addElement(dirList[i]);
    }

    private void processAllDirectoriesInThisDirectory(File f1) {
        addDirs(f1.listFiles(new DirFilter()));
        while (vecDir.size() > 0) {
            File f = nextDir();
            printVerbose("Selected -> " + f);
            printVerbose("Files in this Directory: ");
            addFilesInThisDirectory(f);
            addDirs(f.listFiles(new DirFilter()));
        }

    }

    //-------------------------------------------------------
    // Loop through all the filenames in the current directory
    // and store them in history:
    //-------------------------------------------------------
    private void addFilesInThisDirectory(File f1) {
        File ls[] = f1.listFiles(new WildFilter(suffix));
        if (ls == null) return;
        for (int i = 0; i < ls.length; i++)
            addFile(ls[i]);
    }

    private void addFile(File f2) {
        int bytes = Futil.available(f2);
        totalBytes += bytes;
        printVerbose(f2 +
                " has " +
                bytes + " bytes");
        history.addElement(f2);
    }

    public File getStartDir() {
        return startDir;
    }


    public File[] getFiles() {
        File f[] = new File[history.size()];
        history.copyInto(f);
        return f;
    }

    public int getTotalBytes() {
        return totalBytes;
    }

    public int getTotalFiles() {
        return history.size();
    }

    public String getSuffix() {
        return suffix;
    }

}



