package futils;

import java.io.File;
import java.io.FilenameFilter;

public class DirFilter implements FilenameFilter {
    public boolean accept(File dir, String name) {
        return new File(dir, name).isDirectory();
    }

    public static File[] getDirFiles() {
        File f = Futil.getReadDirFile("select a file");
        return f.listFiles(new DirFilter());
    }

    // Test the DirFilter:
    public static void main(String args[]) {
        File dirs [] = getDirFiles();
        System.out.println("These are just dirs:");
        for (int i = 0; i < dirs.length; i++)
            System.out.println(dirs[i]);
    }
}
