package futils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;


public class CsvReader {
    private BufferedReader br;
    private Vector v = new Vector();

    public CsvReader(BufferedReader _br) {
        br = _br;
        getLines();
        System.out.println("read " + v.size() + " lines");
        System.out.println("number of bad records=" + numberOfBadRecords);
    }

    private int numberOfBadRecords = 0;

    class Address {
        String lastName = "";
        String firstName = "";
        String address1 = "";
        String address2 = "";
        String address3 = "";
        String address4 = "";
        String address5 = "";
        String homePhone = "";
        String businessPhone = "";
        String faxPhone = "";

        Address(String s[]) {
            try {
                lastName = s[0];
                firstName = s[1];
                address1 = s[2];
                address2 = s[3];
                address3 = s[4];
                address4 = s[5];
                address5 = s[6];
                homePhone = s[7];
                businessPhone = s[8];
                faxPhone = s[9];
            } catch (ArrayIndexOutOfBoundsException e) {
                numberOfBadRecords++;
            }
        }

        private String outLine(String s) {
            if (s.equals("")) return s;
            return "\n" + s;
        }

        public String toString() {
            return outLine("---")
                    + outLine(firstName + " " + lastName)
                    + outLine(address1)
                    + outLine(address2)
                    + outLine(address3)
                    + outLine(address4)
                    + outLine(address5)
                    + outLine(homePhone)
                    + outLine(businessPhone)
                    + outLine(faxPhone);
        }

    }

    public String getRecord(int i) {
        return v.elementAt(i).toString();
    }

    private void processLine(String l) {
        v.addElement(new Address(
                new CsvParser(l).getTokens()
        ));
    }

    private void getLines() {
        try {
            for (String l = br.readLine();
                 l != null; l = br.readLine())
                processLine(l);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        CsvReader cr = new CsvReader(
                ReaderUtil.getBufferedReader(
                        Futil.getReadFile("Select a CSV file")
                )
        );
        System.out.println(
                cr.getRecord(0)
                + cr.getRecord(1)
                + cr.getRecord(2)
                + cr.getRecord(3));
    }

    public void setBr(java.io.BufferedReader br) {
        this.br = br;
    }

    public void setV(java.util.Vector v) {
        this.v = v;
    }

    public void setNumberOfBadRecords(int numberOfBadRecords) {
        this.numberOfBadRecords = numberOfBadRecords;
    }
}