package futils;

import java.io.*;


public final class Cat {

    private Cat() {
    }

    static public void toConsole2(String suffix) {
        File files[] = Ls.getWildFiles(suffix);
        for (int i = 0; i < files.length; i++)
            Cat.toConsole(ReaderUtil.getBufferedReader(
                    files[i]));
    }


    static public void toFile(String suffix) {
        File files[] = Ls.getWildFiles(suffix);
        BufferedWriter bw =
                WriterUtil.getBufferedWriter("select an output for the *" + suffix + " files");
        for (int i = 0; i < files.length; i++)
            fileToWriter(files[i], bw);
        WriterUtil.close(bw);
    }

    /**
     *  use the suffix to select a bunch of files and
     * write these files to a single file.
     */
    static public void wildToFile(String suffix, FileWriter fw) {

        try {
            File files[] = Ls.getWildFiles(suffix);
            if (files == null) {
                System.out.println("ER!:wildToFile, files==null");
                return;
            }
            System.out.println("will process " + files.length + " files");
            PrintWriter pw = new PrintWriter(fw);
            for (int i = 0; i < files.length; i++)
                fileToStream(
                        new BufferedReader(
                                new FileReader(files[i])), pw);
            fw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testWildToFile() {
        wildToFile(".java",
                WriterUtil.getFileWriter("select output file"));
    }

    static public void javasToConsole2() {
        File files[] = Ls.getWildFiles("java");
        for (int i = 0; i < files.length; i++)
            fileToConsole(
                    files[i]);
    }


    static public void fileToConsole(File f) {
        try {
            System.out.println("cat: " + f);
            FileReader fr = new FileReader(f);
            String line;
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null)
                System.out.println(line);
            br.close();
        } // try
        catch (Exception exe) {
            System.out.println("cat:Error on input file");
        }
    }

    static public void fileToWriter(File f, BufferedWriter bw) {
        System.out.println("cat: " + f);
        BufferedReader br =
                ReaderUtil.getBufferedReader(f);
        for (String line = ReaderUtil.readLine(br);
             line != null; line = ReaderUtil.readLine(br)) {
            WriterUtil.println(bw, line);
        }
        ReaderUtil.close(br);
    }

    public static void toConsole() {
        toConsole(ReaderUtil.getBufferedReader(
                Futil.getReadFile(
                        "select a file to Cat.listFilesToConsole()")));
    }

    static public void toConsole(BufferedReader br) {
        String line;
        while ((line = ReaderUtil.readLine(br)) != null)
            System.out.println(line);
        ReaderUtil.close(br);
    }

    static public void fileToStream(
            BufferedReader br, PrintWriter pw) {
        String line;
        try {

            while ((line = br.readLine()) != null)
                pw.println(line);
            br.close();
        } // try
        catch (Exception exe) {
            System.out.println("cat:Error on input file");
        }
    }

    public static void main(String args[]) {
        testWildToFile();
        System.out.println("done!");
    }

}