package face;

public interface xxxFile {
    /**
     * Get the height of the PPM image.
     *
     * @return the height of the image.
     */
    public int getHeight();

    /**
     * Get the width of the PPM image.
     *
     * @return  the width of the image.
     */
    public int getWidth();

    /**
     * Get the data as byte array. Data is of any type that
     * has been read from the file (usually 8bit RGB)
     *
     * @return  The data of the image.
     */
    public byte[] getBytes();

    /**
     * Get the data as double array. Data is of any type that
     * has been read from the file (usually 8bit RGB put into an 64bit double)
     *
     * @return  The data of the image.
     */
    public double[] getDouble();
}
