package examples.observables;

import java.util.Observable;
import java.util.Observer;

public class ObserverOfPoint3d implements Observer {
    public void update(Observable observable,
                       Object o) {
        System.out.println("observable =" +
                observable);
        System.out.println(observable.getClass().getName());
        System.out.println("argument=" +
                o);
        ObservablePoint3d p3d = (ObservablePoint3d) (observable);
        System.out.println("got points! d1,d2,d3=" +
                p3d.getD1() + "," + p3d.getD2() + "," + p3d.getD3());
    }

}


class Mediator {
    ObservablePoint3d op3d = new ObservablePoint3d();
    ObserverOfPoint3d observer = new ObserverOfPoint3d();

    public void wire() {
        op3d.addObserver(observer);
        op3d.setD1(-99);
        op3d.notifyObservers();
    }

    public static void main(String args[]) {
        Mediator m = new Mediator();
        m.wire();
    }
}
