package examples.observables;

import java.util.Observable;

public class ObservablePoint3d extends Observable {
    private double d1 = 0;
    private double d2 = 0;
    private double d3 = 0;

    public void setD1(double _d) {
        if (d1 != _d) {
            d1 = _d;
            setChanged();
            super.notifyObservers(this);
        }
    }

    public void setD2(double _d) {
        if (d2 != _d) {
            d2 = _d;
            setChanged();
            super.notifyObservers(this);
        }
    }

    public void setD3(double _d) {
        if (d3 != _d) {
            d3 = _d;
            setChanged();
            super.notifyObservers(this);
        }
    }

    public double getD1() {
        return d1;
    }

    public double getD2() {
        return d2;
    }

    public double getD3() {
        return d3;
    }

    public String toString() {
        return "d1,d2,d3=" + d1 + "," + d2 + "," + d3;
    }
}
