/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 4, 2004
 * Time: 4:31:18 PM
 * To change this template use Options | File Templates.
 */
package examples.fsm;

import java.util.Observable;
import java.util.Observer;

public class ObservableClock extends Observable
        implements Runnable {
    Thread t = new Thread(this);
    private long milliseconds = 1000;

    public ObservableClock(long milliseconds) {
        this.milliseconds = milliseconds;
        t.start();
    }

    public void run() {
        while (true) {
            try {
                this.setChanged();
                this.notifyObservers();
                Thread.sleep(milliseconds);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String args[]) {
        ObservableClock oc = new ObservableClock(1000);
        Observer o = new Observer() {
            public void update(Observable obs, Object obj) {
                System.out.println(obs);
            }

        };
        oc.addObserver(o);
    }
}
