package examples.ch16;

import java.io.*;

import futils.*;

public class QuestionParser {
    public static void main(String args[]) {
        BufferedReader br =
                futils.ReaderUtil.getBufferedReader(
                        "select a test file");
        toConsole(br);
        futils.ReaderUtil.close(br);
    }

    private static void promptUserTest() {
        BufferedReader br = new BufferedReader(
                new InputStreamReader(System.in));
        System.out.print(getUserAnswer(
                "is java cool?", br));
    }

    public static String getString(BufferedReader br) {
        try {
            return br.readLine();
        } catch (IOException e) {
            return null;
        }
    }

    public static boolean getUserAnswer(String prompt, BufferedReader br) {
        System.out.print(prompt + ":");
        String ans = getString(br);
        return ans.equals("t");
    }

    public static void readQuestion(String s) {
        System.out.println("question=" + s);

    }

    static public void toConsole(BufferedReader br) {

        for (String line = ReaderUtil.readLine(br);
             line != null;
             line = ReaderUtil.readLine(br)) {
            System.out.println(line);
        }
        ReaderUtil.close(br);
    }

}

class Question {
    boolean answer = true;
    String question = null;

    public static void test() {
        System.out.println(
                new examples.ch16.Question("TRUE java is cool"));
        System.out.println(
                new examples.ch16.Question("false fortran is cool"));
        System.out.println(
                new examples.ch16.Question("wdlifjewoij java is cool"));
        System.out.println(
                new examples.ch16.Question("true 4+4=8"));
    }

    Question(String s) {
        int i = s.indexOf(' ');
        String ans = s.substring(0, i);
        question = s.substring(i);
        answer = (Boolean.valueOf(ans)
                ).booleanValue();
    }

    public String toString() {
        return question + ":" + answer;
    }
}