package examples.array;

public class CharacterGraphics {
    char screen[][] = new char[20][20];

    public void dot(int x, int y) {
        if (x < 0) return;
        if (y < 0) return;
        if (x >= screen.length) return;
        if (y >= screen[0].length) return;
        screen[y][x] = '*';
    }

    public void circle(int xc, int yc, int r) {
        for (double t = 0; t < 1; t = t + .01) {
            int ix = (int) (t * 20);
            double x = t * 2 * Math.PI;
            ix = (int) (r * Math.sin(x) + xc);
            int iy = (int) (r * Math.cos(x) + yc);
            dot(ix, iy);
        }
    }

    public void diag() {
        for (int i = 0; i < screen.length; i++)
            for (int j = 0; j < screen[i].length; j++)
                if (i == j)
                    screen[i][j] = '*';
    }

    public void fillScreen(char fillChar) {
        for (int i = 0; i < screen.length; i++)
            for (int j = 0; j < screen[i].length; j++)
                screen[i][j] = fillChar;
    }

    public void printScreen() {
        for (int i = screen.length - 1; i > 0; i--) {
            for (int j = 0; j < screen[i].length; j++)
                System.out.print(screen[i][j]);
            System.out.println();
        }
    }

    public void axis() {
        for (int i = 0; i < screen.length; i++)
            for (int j = 0; j < screen[i].length; j++) {
                if (i == 1)
                    screen[i][j] = '-';
                if (j == 0)
                    screen[i][j] = '|';

            }
        screen[1][screen[1].length - 2] = '>';
        screen[1][screen[1].length - 1] = 'x';

        screen[screen[0].length - 2][0] = '^';
        screen[screen[0].length - 1][0] = 'y';
    }

    public void print(Object a[]) {
        for (int i = 0; i < a.length; i++)
            System.out.println(a[i]);
    }


    public static void main(String args[]) {
        CharacterGraphics at = new CharacterGraphics();
        at.fillScreen('.');
        at.axis();
        at.circle(5, 5, 5);
        at.diag();
        at.printScreen();
    }
}
