package examples;

public class ThisTest {
    public static void main(String args[]) {
        ThisTest tt = new ThisTest();
        tt.print();
    }

    public void print() {
        System.out.println(this);
    }

    public String toString() {
        return "Hello from ThisTest!!";
    }
}

class Constructor {
    int x,y;

    Constructor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    Constructor() {
        this(10, 20); // default values
    }

    void print() {
        System.out.println("x,y=" + x + "," + y);
    }

    public static void main(String args[]) {
        Constructor c = new Constructor();
        c.print();
    }
}

class OuterThis {
    int x = 10;
    Inner i = new Inner();

    public static void main(String args[]) {
        OuterThis o = new OuterThis();
        o.i.print();
    }

    class Inner {
        int x = 20;

        void print() {
            System.out.println("inner x= " + x);
            System.out.println("outer x= " + OuterThis.this.x);
        }
    }
}

