package addBk.address;

import java.awt.*;
import java.sql.*;
import java.util.Vector;

public class SimpleSelect {
    private String url =
            "jdbc:odbc:AddressBook";
    private String query =
            "SELECT * FROM ";
    private String driverClassName =
            "sun.jdbc.odbc.JdbcOdbcDriver";

    private Connection con = null;
    private String catalogName = null;
    private DatabaseMetaData dma = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmd = null;
    private String keywords = null;
    private boolean isReadOnly = false;
    private boolean usesLocalFiles = false;
    private String driverName = null;

    private String selectedTable = null;

    private ResultSet tables_rs = null;
    private ResultSetMetaData
            tables_rsmd = null;
    private String tableFields[] = null;

    private Vector tableVector =
            new Vector();
    private String tableNames[] = null;

    private String nonMSysTables[] = null;

    private Vector v = null;


    public void connect() {
        try {
            safeConnect();
        } catch (SQLException e) {
            print(e);
        } catch (ClassNotFoundException e) {
            print(e);
        }
    }

    public void safeConnect() throws
            SQLException, ClassNotFoundException {
        safeLoadDriver();
        //DriverManager.setLogStream(System.out);
        con =
                DriverManager.getConnection(
                        url, "", "");
        dma = con.getMetaData();
        catalogName =
                con.getCatalog();
        isReadOnly = con.isReadOnly();
        usesLocalFiles =
                dma.usesLocalFiles();
        driverName =
                dma.getDriverName();

        initTableNames();
        createStatement();
    }

    public String getSelectedTable() {
        return selectedTable;
    }

    public void createStatement() {
        try {
            stmt = con.createStatement();
        } catch (SQLException e) {
            print(e);
        }
    }

    public void printKeywords() {
        println("Non SL92 keywords:");
        println(getKeywords());
    }

    public String[] getNonMSysTableNames() {
        return nonMSysTables;
    }

    public void initNonMSysTables() {
        int n
                = tableNames.length -
                getNumberOfMSysTables();
        nonMSysTables = new String[n];
        for (int i = 0; i < n; i++) {
            nonMSysTables[i]
                    = tableNames[i + getNumberOfMSysTables()];
        }

    }

    private int getNumberOfMSysTables() {
        int k = 0;
        for (int i = 0; i < tableNames.length; i++)
            if (tableNames[i].startsWith("MSys"))
                k++;
        return k;
    }

    private void initTableNames() {
        try {
            tables_rs =
                    dma.getTables(
                            null,
                            null, null, null);
            tables_rsmd =
                    tables_rs.getMetaData();
            tableFields =
                    getColumnNames(tables_rsmd);
            while (tables_rs.next())
                tableVector.addElement(
                        tables_rs.getString("TABLE_NAME"));
        } catch (SQLException e) {
            print(e);
        }
        int n = tableVector.size();
        tableNames =
                new String[n];
        for (int i = 0; i < n; i++)
            tableNames[i]
                    = (String)
                    tableVector.elementAt(i);
        initNonMSysTables();

    }

    public String[] getTableNames() {
        return tableNames;
    }

    public void printProductName() {
        print("The database product name is:");
        println(getProductName());
    }

    public String getProductName() {
        try {
            return
                    dma.getDatabaseProductName();
        } catch (SQLException e) {
            print(e);
        }
        return null;
    }

    public void printTableTypes() {
        println("The table types are:");
        ResultSet rs
                = getTableTypes();
        try {
            while (rs.next()) {
                String s = rs.getString("TABLE_TYPE");
                println("   " + s);
            }
        } catch (SQLException e) {
            print(e);
        }

    }

    public ResultSet getTableTypes() {
        try {
            return
                    dma.getTableTypes();
        } catch (SQLException e) {
            print(e);
        }
        return null;
    }

    /**
     keywords that are not also SQL92 keywords.
     */
    public String getKeywords() {
        try {
            return
                    dma.getSQLKeywords();
        } catch (SQLException e) {
            print(e);
        }
        return null;
    }

    public void loadDriver() {
        try {
            safeLoadDriver();
        } catch (ClassNotFoundException e) {
            println(e);
        }
    }

    public void safeLoadDriver() throws ClassNotFoundException {
        Class.forName(
                driverClassName);
    }

    public void printInfo() {
        printProductName();
        println("catalogName=" + catalogName);
        printTableTypes();
        printKeywords();
        println("is ReadOnly=" + getReadOnly());
        println("usesLocalFiles=" + getUsesLocalFiles());
        println("driverName=" + driverName);
        println("tableFields=");
        print(tableFields);
        println("tableNames=");
        print(tableNames);
        println("number of MSysTables="
                + getNumberOfMSysTables());
        println("Non MSysTables=");
        print(getNonMSysTableNames());

    }

    public boolean getUsesLocalFiles() {
        return usesLocalFiles;
    }

    public boolean getReadOnly() {
        return isReadOnly;
    }

    public String getCatalogName() {
        return catalogName;
    }


    public String getDriverName() {
        return driverName;
    }

    public void print(Object o) {
        System.out.print(o);
    }

    public void println(Object o) {
        System.out.println(o);
    }

    public void println(String s[]) {
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i]);
    }

    public void getQuery() {
        getQuery("Authors");
    }

    public void getQuery(String _selectedTable) {
        selectedTable = _selectedTable;
        query =
                "SELECT * FROM " + selectedTable;
        try {
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
        } catch (SQLException e) {
            print(e);
        }
    }

    public void setQuery(String q) {
        query = q;
        rs = null;
    }

    public void printDebug() {
        try {
            checkForWarning(con.getWarnings());
            println("\nConnected to " + dma.getURL());
            println("Driver " +
                    dma.getDriverName());
            println("Version " +
                    dma.getDriverVersion());
            println("");
        } catch (SQLException e) {
            print(e);
        }
    }

    public void display() {
        try {
            dispResultSet();
        } catch (SQLException e) {
            print(e);
        }
    }

    private void print(SQLException ex) {
        println("\n*** SQLException caught ***\n");
        while (ex != null) {
            println("SQLState: " +
                    ex.getSQLState());
            println("Message: " + ex.getMessage());
            println("Vendor: " +
                    ex.getErrorCode());
            ex = ex.getNextException();
            println("");
        }
        // Got some other type of exception. Dump it.
        ex.printStackTrace();
    }

    public void print(String s[]) {
        for (int i = 0; i < s.length; i++)
            print(s[i] + ",");
        println("");
    }

    public void close() {
        try {
            rs.close();
            stmt.close();
            con.close();
        } catch (SQLException e) {
            print(e);
        }
    }

    public static void main(String args[]) {
        SimpleSelect ss
                = new SimpleSelect();
        ss.connect();
        ss.getQuery();
        //ss.printColumnNames();
        ss.printInfo();
        //ss.printRows();
        ss.close();
    }
//-------------------------------------------------------------------
// checkForWarning
// Checks for and displays warnings. Returns true if a warning
// existed
//-------------------------------------------------------------------
    private boolean checkForWarning(SQLWarning warn) {
        boolean rc = false;
        // If a SQLWarning object was given, display the
        // warning messages. Note that there could be
        // multiple warnings chained together
        if (warn != null) {
            println("\n *** Warning ***\n");
            rc = true;
            while (warn != null) {
                println("SQLState: " +
                        warn.getSQLState());
                println("Message: " +
                        warn.getMessage());
                println("Vendor: " +
                        warn.getErrorCode());
                println("");
                warn = warn.getNextWarning();
            }
        }
        return rc;
    }

    public String[] getColumnNames() {
        return getColumnNames(rsmd);
    }

    public String[] getColumnNames(ResultSetMetaData r) {
        String s []
                = new String[getNumberOfColumns(r)];
        try {
            for (int i = 1; i <= s.length; i++)
                s[i - 1] = r.getColumnLabel(i);
        } catch (SQLException e) {
            print(e);
        }

        return s;
    }

    public String[] getColumnNames(ResultSet r) {
        try {
            return
                    getColumnNames(
                            r.getMetaData());
        } catch (SQLException e) {
            print(e);
        }
        return null;
    }

    public Label[] getColumnLabels() {
        String s[]
                = getColumnNames();
        Label l[] = new Label[s.length];
        for (int i = 0; i < s.length; i++)
            l[i] = new Label(s[i]);
        return l;
    }

    public void printNumberOfColumns() {
        System.out.println(
                getNumberOfColumns());
    }

    public int getNumberOfColumns() {
        return getNumberOfColumns(rsmd);
    }

    private int getNumberOfColumns(ResultSetMetaData r) {
        int i = -1;
        try {
            i = r.getColumnCount();
        } catch (SQLException e) {
            print(e);
        }
        return i;
    }

    public void printColumnNames() {
        String s[] = getColumnNames();
        for (int i = 0; i < s.length; i++)
            print(s[i] + ",");
        println("");
    }

    public String[] getRowAsString() {
        int N = getNumberOfColumns();
        String s[] = new String[N];
        try {
            for (int i = 0; i < N; i++)
                s[i] = rs.getString(i + 1);
        } catch (SQLException e) {
            print(e);
        }
        return s;
    }

    public void printVector() {
        for (int i = 0; i < v.size(); i++) {
            String s[]
                    = getRowAt(i);
            print(s);
        }
    }

    public int getNumberOfRows() {
        return v.size();
    }

    public String[] getRowAt(int i) {
        return (String[]) v.elementAt(i);
    }

    public void printRow() {
        String s[]
                = getRowAsString();
        for (int i = 0; i < s.length; i++) {
            print(s[i] + ", ");
        }
        println("");
    }

    /**
     Download entire database!
     Danger Will Robinson,
     Take cover Dr. Smith!!
     */
    public Vector getRows() {
        if (v != null) return v;
        v = new Vector();
        while (nextRow())
            v.addElement(getRowAsString());
        return v;
    }

    public void printRows() {
        while (nextRow())
            printRow();
    }

    public boolean nextRow() {
        try {
            return rs.next();
        } catch (SQLException e) {
            print(e);
            return false;
        }
    }


//-------------------------------------------------------------------
// dispResultSet
// Displays all columns and rows in the given result set
//-------------------------------------------------------------------
    private void dispResultSet() throws SQLException {
        int i;
        printColumnNames();
        // Display data, fetching until end of the result set
        boolean more = rs.next();
        int numCols = getNumberOfColumns();
        while (more) {
            // Loop through each column, getting the
            // column data and displaying
            for (i = 1; i <= numCols; i++) {
                if (i > 1) print(",");
                print(rs.getString(i));
            }
            println("");
            // Fetch the next result set row
            more = rs.next();
        }
    }

}