package addBk.address;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;


class PreviousButton extends Button {
    //implements Runnable {
    PreviousButton() {
        super("Prev");
    }

    public void run() {
        //System.out.println("Run previous");
    }
}

class NextButton extends Button
        implements Runnable {
    NextButton() {
        super("Next");
    }

    public void run() {
        //System.out.println("Run next");
    }
}

class IndexButton extends Button
        implements Runnable {
    IndexButton() {
        super("Index");
    }

    public void run() {
        System.out.println("Run index");
    }

    public void hi() {
        System.out.println("Hello World");
    }
}

public class NavigationPanel
        extends Panel
        implements ActionListener {

    PreviousButton prevButton
            = new PreviousButton();

    Button nextButton
            = new NextButton();

    Button indexButton
            = new IndexButton();

    public void setNavigationListener(
            ActionListener a) {
        nextButton.addActionListener(a);
        prevButton.addActionListener(a);
        indexButton.addActionListener(a);
    }

    public void
            actionPerformed(ActionEvent e) {
        //Button b = (Button)e.getSource();
        // ((Runnable)b).gui.run();
    }

    public void focusLost(FocusEvent e) {
        System.out.println("blur ");
    }

    public void focusGained(FocusEvent e) {
        System.out.println("sharp");
    }


    NavigationPanel() {
        setLayout(
                new GridLayout(0, 1));
        add(prevButton);
        add(nextButton);
        add(indexButton);
        prevButton.addActionListener(this);
        nextButton.addActionListener(this);
        indexButton.addActionListener(this);
    }
}