package addBk.address;

import java.util.Vector;
import java.sql.SQLException;

final class CachedDatabase {
    private static CachedDatabase cdb = new CachedDatabase();

    public static CachedDatabase getCachedDatabase() {
        return cdb;
    }

    private CachedDatabase() {
    } //singleton pattern

    private Vector
            v = new Vector();

    private Vector
            addressVector = new Vector();

    SimpleSelect ss
            = new SimpleSelect();

    Vector rows = null;

    public void init() {
        try {
            ss.safeConnect();
            // The following is the table name!
            ss.getQuery("Addresses");
            rows = ss.getRows();
            ss.close();
            initAddresses();
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } finally {
            System.out.println("could not connect to sql database, RDBMS setup correctly?"
                    + "program continues...");
        }

    }

    public void initAddresses() {
        for (int i = 0; i < rows.size(); i++) {
            addAddress(
                    new AddressRecord((String[])
                    rows.elementAt(i)));
        }
    }

    public void addAddress(AddressRecord a) {
        addressVector.addElement(a);
    }

    public void print() {
        for (int i = 0; i <
                getSize(); i++) {
            (get(i)).print();
        }
    }

    public void print(String s[]) {
        for (int i = 0; i < s.length; i++) {
            System.out.print(s[i] + ",");

        }

    }

    public static void main(String args[]) {
        CachedDatabase
                cd = new CachedDatabase();
        cd.init();
        cd.print();

    }

    public void sort() {
        Sort.bubble(addressVector);
    }

    public void add(AddressRecord a) {
        v.addElement(a);
    }

    public AddressRecord get(int i) {
        try {
            return
                    (AddressRecord)
                    addressVector.elementAt(i);
        } catch (ArrayIndexOutOfBoundsException e) {
            return new AddressRecord();
        }
    }

    public int getSize() {
        return addressVector.size();
    }
}