package addBk.AddressBook;

//NavigationPanel.java


import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;

public class NavigationPanel
        extends Panel
        implements ActionListener {

    PreviousButton prevButton
            = new PreviousButton();

    Button nextButton
            = new NextButton();

    Button indexButton
            = new IndexButton();

    Button editButton
            = new EditButton();

    public void
            actionPerformed(ActionEvent e) {
        ((Runnable)
                e.getSource()).run();
    }

    public void focusLost(FocusEvent e) {
        System.out.println("blur ");
    }

    public void focusGained(FocusEvent e) {
        System.out.println("sharp");
    }


    NavigationPanel() {
        setLayout(
                new GridLayout(0, 1));
        add(prevButton);
        add(nextButton);
        add(indexButton);
        add(editButton);
        prevButton.addActionListener(this);
        nextButton.addActionListener(this);
        indexButton.addActionListener(this);
        editButton.addActionListener(this);
    }

    public class PreviousButton extends Button
            implements Runnable {
        PreviousButton() {
            super("Prev");
        }

        public void run() {
            System.out.println("Run previous");
            AddressDisplay display =
                    new AddressDisplay();
            if (display.isEditFlag())
                display.saveCurrentRecord();
            display.prevRecord();
        }
    }

    public class NextButton extends Button
            implements Runnable {
        NextButton() {
            super("Next");
        }

        public void run() {
            System.out.println("Run next");
            AddressDisplay display =
                    new AddressDisplay();
            if (display.isEditFlag())
                display.saveCurrentRecord();
            display.nextRecord();
        }
    }

    public class IndexButton extends Button
            implements Runnable {
        IndexButton() {
            super("Index");
        }

        public void run() {
            System.out.println("Run index");
            AddressDisplay display =
                    new AddressDisplay();
            display.toggleIndexDisplay();
        }
    }

    public class EditButton extends Button
            implements Runnable {
        EditButton() {
            super("Edit");
        }

        public void run() {
            System.out.println("Run edit");
            AddressDisplay display =
                    new AddressDisplay();
            if (display.isEditFlag())
                display.saveCurrentRecord();
            display.toggleEditPanel();
        }
    }


} // end class NavigationPanel
