package addBk.AddressBook;

import javax.swing.*;
import java.awt.*;
import java.io.*;


public class CSVExport {
    static boolean isSwing = false;

    public CSVExport(AddressBookDatabase abd) {

        try {
            BufferedWriter bw = getWriter("select a CSV file for export");
            for (int i = 0; i < (abd.getNumRecords()); i++) {
                AddressBookRecord abr = abd.readRecord(i);
                bw.write(abr.name + ",");
                bw.write(abr.address + ",");
                bw.write(abr.notes + ",");
                bw.write(abr.dial_1 + ",");
                bw.write(abr.dial_2 + ",");
                bw.write(abr.dial_3 + ",");
                bw.newLine();
            } // end for
            bw.close();
        } catch (FileNotFoundException e) {
        } catch (IOException e) {
        }

    }  // end constructor

    public static File getFile(String prompt) {
        return new File(Futil.getWriteFileName(prompt));
    }

    public static BufferedWriter getWriter(String prompt)
            throws FileNotFoundException, IOException {
        return new BufferedWriter(
                new OutputStreamWriter(
                        new FileOutputStream(getFile(prompt))));
    }

    static class Futil {
        public static File JGetReadFile(
                String prompt) {
            JFileChooser jfc = new JFileChooser();
            jfc.showOpenDialog(new JFrame());
            return jfc.getSelectedFile();
        }

        public static String getReadFileName(
                String prompt) {
            FileDialog fd = new FileDialog(
                    new Frame(), prompt);
            fd.setVisible(true);
            fd.setVisible(false);
            return fd.getDirectory() + fd.getFile();
        }

        public static String getWriteFileName(
                String prompt) {
            FileDialog fd = new FileDialog(
                    new Frame(), prompt, FileDialog.SAVE);
            fd.setVisible(false);
            fd.setVisible(true);
            return fd.getDirectory() + fd.getFile();
        }
    } // end class Futil
} // end CSVExport
