package addBk.AddressBook;

//AddressDisplay.java


public class AddressDisplay
        extends AddressBookFrame {
    private static AddressBookRecord storageRecord;
    private static boolean editFlag = false;
    private static boolean emptyDb = true;

    private static AddressBookFrame adf =
            new AddressBookFrame();
    private static AddressBookDatabase abd =
            new AddressBookDatabase();
    private static AddressDisplay display =
            new AddressDisplay();

    public static void setTextFieldValues(AddressBookRecord abr) {
        adf.getTf().setText(abr.name);
        adf.getAp().t0.setText(abr.address);
        adf.getAp().t1.setText(abr.notes);
        adf.getTbp().tfp.t0.setText(abr.dial_1);
        adf.getTbp().tfp.t1.setText(abr.dial_2);
        adf.getTbp().tfp.t2.setText(abr.dial_3);
        adf.getEditPanel().tfp.t0.setText(abr.dial_1);
        adf.getEditPanel().tfp.t1.setText(abr.dial_2);
        adf.getEditPanel().tfp.t2.setText(abr.dial_3);
    }

    public AddressBookRecord getTextFieldValues() {
        AddressBookRecord abr =
                new AddressBookRecord();
        abr.name = adf.getTf().getText();
        abr.address = adf.getAp().t0.getText();
        abr.notes = adf.getAp().t1.getText();
        if (!isEditMode()) {
            abr.dial_1 = adf.getTbp().tfp.t0.getText();
            abr.dial_2 = adf.getTbp().tfp.t1.getText();
            abr.dial_3 = adf.getTbp().tfp.t2.getText();
        } else {
            abr.dial_1 = adf.getEditPanel().tfp.t0.getText();
            abr.dial_2 = adf.getEditPanel().tfp.t1.getText();
            abr.dial_3 = adf.getEditPanel().tfp.t2.getText();
        }
        return (abr);
    }

    public void nextRecord() {
        abd.incrementRecord();
        storageRecord = (abd.readRecord());
        AddressDisplay.setTextFieldValues(abd.readRecord());
    }

    public void prevRecord() {
        abd.decrementRecord();
        storageRecord = (abd.readRecord());
        AddressDisplay.setTextFieldValues(abd.readRecord());
    }

    public void addRecord() {
        AddressBookRecord abr = display.getTextFieldValues();
        abd.addRecord(abr);
        storageRecord = (abd.readRecord());
        adf.getIndexPanel().indexList.add(abr.name);
        display.setIndexItems();
        display.editFlag = false;
    }

    public void deleteCurrentRecord() {
        abd.deleteCurrentRecord();
        display.setIndexItems();
        display.editFlag = false;
        storageRecord = (abd.readRecord());
    }

    public void saveCurrentRecord() {
        System.out.println("saving current record");
        abd.saveCurrentRecord(getTextFieldValues());
        abd.sort();
        display.setIndexItems();
        storageRecord = (abd.readRecord());
        display.editFlag = false;
    }

    public void revertRecord() {
        //System.out.println("reverting current record");
        abd.saveCurrentRecord(storageRecord);
        storageRecord = (abd.readRecord());
        AddressDisplay.setTextFieldValues(abd.readRecord());
        display.editFlag = false;
    }

    public void setEditFlag() {
        display.editFlag = true;
    }

    public void toggleIndexDisplay() {
        if (isIndexToggle() == true) {
            setIndexToggle(false);
            adf.init();
        } else {
            setIndexToggle(true);
            adf.init();
        }
    }

    public void setIndexItems() {
        adf.getIndexPanel().indexList.removeAll();
        for (int i = 0; i < (abd.getNumRecords()); i++) {
            AddressBookRecord abr = abd.readRecord(i);
            adf.getIndexPanel().indexList.add(abr.name);
        } // end for
    }

    public void setRecord(int i) {
        abd.setRecordNumber(i);
        AddressBookRecord abr = abd.readRecord();
        AddressDisplay.setTextFieldValues(abr);
        storageRecord = (abd.readRecord());
    }

    public void toggleEditPanel() {
        if (isEditMode() == true) {
            setEditMode(false);
            adf.getTf().setEditable(false);
            adf.getAp().t0.setEditable(false);
            adf.getAp().t1.setEditable(false);
            adf.init();
            System.out.println("Edit mode OFF");
        } else {
            setEditMode(true);
            adf.getTf().setEditable(true);
            adf.getAp().t0.setEditable(true);
            adf.getAp().t1.setEditable(true);
            adf.init();
            System.out.println("Edit mode ON");

            if (emptyDb) {
                // auto add record in edit mode when none
                AddressBookRecord abr =
                        new AddressBookRecord();
                abr.name = "new record";
                AddressDisplay.setTextFieldValues(abr);
                display.addRecord();
                emptyDb = false;
            }

        }
    }

    public void dbMerge() {
        new CSVMerge(abd);
        abd.sort();
        display.setRecord(0);
        display.setIndexItems();
        emptyDb = false;
    }

    public void dbExport() {
        new CSVExport(abd);
    }

    public void dbOpen() {
        abd.openDb();
        AddressDisplay.setTextFieldValues(abd.readRecord());
        display.setRecord(0);
        display.setIndexItems();
        emptyDb = false;
    }

    public void dbSave() {
        abd.saveDb();
    }

    public static AddressBookRecord getStorageRecord() {
        return storageRecord;
    }

    public static void setStorageRecord(AddressBookRecord storageRecord) {
        AddressDisplay.storageRecord = storageRecord;
    }

    public static boolean isEditFlag() {
        return editFlag;
    }

    public static void setEditFlag(boolean editFlag) {
        AddressDisplay.editFlag = editFlag;
    }

    public static boolean isEmptyDb() {
        return emptyDb;
    }

    public static void setEmptyDb(boolean emptyDb) {
        AddressDisplay.emptyDb = emptyDb;
    }

    public static AddressBookFrame getAdf() {
        return adf;
    }

    public static void setAdf(AddressBookFrame adf) {
        AddressDisplay.adf = adf;
    }

    public static AddressBookDatabase getAbd() {
        return abd;
    }

    public static void setAbd(AddressBookDatabase abd) {
        AddressDisplay.abd = abd;
    }

    public static AddressDisplay getDisplay() {
        return display;
    }

    public static void setDisplay(AddressDisplay display) {
        AddressDisplay.display = display;
    }

}
