package addBk.AddressBook;

//AddressBookFrame.javaAddressBookFrame.java


import java.awt.*;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AddressBookFrame
        extends Frame implements TextListener {

    private static boolean indexToggle = false;
    private static boolean editMode = false;
    private static boolean runOnce = false;

    private AddressPanel ap =
            new AddressPanel();
    private TextButtonPanel tbp =
            new TextButtonPanel();
    private TextField tf =
            new TextField("Name Field");
    private IndexPanel ip =
            new IndexPanel();
    private EditPanel ep =
            new EditPanel();
    private MenuBar abmb =
            new AddressBookMenu();

    public AddressBookFrame() {
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                setVisible(false);
                dispose();
                System.exit(0);
            }
        });

    }// end of constructor Closable JFrame


    // init gets called each time you need to toggle editMode or indexpanel
    public void init() {
        setMenuBar(abmb);
        setLayout(new BorderLayout());
        add(tf, "North");
        add(ap, "Center");
        add(tbp, "South");
        add(ep, "South");
        if (!editMode) {
            remove(ep);
            add(tbp, "South");
        } else {
            remove(tbp);
            add(ep, "South");
        }
        add(ip, "East");
        if (!indexToggle) remove(ip);

        if (!runOnce) { // to protect any resizing
            setSize(400, 400);
            tf.setEditable(false);
            ap.t0.setEditable(false);
            ap.t1.setEditable(false);
        }
        setVisible(true);
        tf.addTextListener(this);
        runOnce = true;

    } // end init

    public void textValueChanged(
            TextEvent e) {
        //System.out.println(e);
        AddressDisplay display =
                new AddressDisplay();
        display.setEditFlag();
    }

    public static boolean isIndexToggle() {
        return indexToggle;
    }

    public static void setIndexToggle(boolean indexToggle) {
        AddressBookFrame.indexToggle = indexToggle;
    }

    public static boolean isEditMode() {
        return editMode;
    }

    public static void setEditMode(boolean editMode) {
        AddressBookFrame.editMode = editMode;
    }

    public static boolean isRunOnce() {
        return runOnce;
    }

    public static void setRunOnce(boolean runOnce) {
        AddressBookFrame.runOnce = runOnce;
    }

    public AddressPanel getAp() {
        return ap;
    }

    public void setAp(AddressPanel ap) {
        this.ap = ap;
    }

    public TextButtonPanel getTbp() {
        return tbp;
    }

    public void setTbp(TextButtonPanel tbp) {
        this.tbp = tbp;
    }

    public TextField getTf() {
        return tf;
    }

    public void setTf(TextField tf) {
        this.tf = tf;
    }

    public IndexPanel getIndexPanel() {
        return ip;
    }


    public EditPanel getEditPanel() {
        return ep;
    }


} // end class AddressBookFrame
